/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.pigx.common.api.encrypt.core;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pig4cloud.pigx.common.api.encrypt.annotation.decrypt.ApiDecrypt;
import com.pig4cloud.pigx.common.api.encrypt.bean.CryptoInfoBean;
import com.pig4cloud.pigx.common.api.encrypt.bean.DecryptHttpInputMessage;
import com.pig4cloud.pigx.common.api.encrypt.config.ApiEncryptProperties;
import com.pig4cloud.pigx.common.api.encrypt.exception.DecryptBodyFailException;
import com.pig4cloud.pigx.common.api.encrypt.util.ApiCryptoUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

@Order(value=1)
@ControllerAdvice
@ConditionalOnProperty(value={"security.api.encrypt.enable"}, havingValue="true", matchIfMissing=true)
public class ApiDecryptRequestBodyAdvice
implements RequestBodyAdvice {
    private static final Logger log = LoggerFactory.getLogger(ApiDecryptRequestBodyAdvice.class);
    private final ApiEncryptProperties properties;
    private final ObjectMapper objectMapper;

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return AnnotationUtil.hasAnnotation((AnnotatedElement)methodParameter.getMethod(), ApiDecrypt.class);
    }

    public Object handleEmptyBody(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        InputStream messageBody = inputMessage.getBody();
        if (messageBody.available() <= 0) {
            return inputMessage;
        }
        CryptoInfoBean cryptoInfoBean = ApiCryptoUtil.getDecryptInfo(parameter);
        if (cryptoInfoBean == null) {
            throw new DecryptBodyFailException("\u83b7\u53d6\u89e3\u5bc6\u6ce8\u89e3\u914d\u7f6e\u4e3a\u7a7a");
        }
        byte[] bodyByteArray = StreamUtils.copyToByteArray((InputStream)messageBody);
        String bodyJsonKey = this.properties.getBodyJsonKey();
        byte[] decryptedBody = null;
        if (StrUtil.isBlank((CharSequence)bodyJsonKey)) {
            decryptedBody = ApiCryptoUtil.decryptData(bodyByteArray, cryptoInfoBean);
        } else {
            Map data = (Map)this.objectMapper.readValue(bodyByteArray, Map.class);
            String content = (String)data.get(bodyJsonKey);
            if (content != null) {
                decryptedBody = ApiCryptoUtil.decryptData(content.getBytes(StandardCharsets.UTF_8), cryptoInfoBean);
            }
        }
        if (decryptedBody == null) {
            throw new DecryptBodyFailException("Decryption error, please check if the selected source data is encrypted correctly. (\u89e3\u5bc6\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u9009\u62e9\u7684\u6e90\u6570\u636e\u7684\u52a0\u5bc6\u65b9\u5f0f\u662f\u5426\u6b63\u786e\u3002)");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(decryptedBody);
        return new DecryptHttpInputMessage(inputStream, inputMessage.getHeaders());
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public ApiDecryptRequestBodyAdvice(ApiEncryptProperties properties, ObjectMapper objectMapper) {
        this.properties = properties;
        this.objectMapper = objectMapper;
    }
}

