/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.pigx.common.api.encrypt.core;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pig4cloud.pigx.common.api.encrypt.annotation.encrypt.ApiEncrypt;
import com.pig4cloud.pigx.common.api.encrypt.bean.CryptoInfoBean;
import com.pig4cloud.pigx.common.api.encrypt.config.ApiEncryptProperties;
import com.pig4cloud.pigx.common.api.encrypt.exception.EncryptBodyFailException;
import com.pig4cloud.pigx.common.api.encrypt.util.ApiCryptoUtil;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@Order(value=1)
@ControllerAdvice
@ConditionalOnProperty(value={"security.api.encrypt.enable"}, havingValue="true", matchIfMissing=true)
public class ApiEncryptResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(ApiEncryptResponseBodyAdvice.class);
    private final ApiEncryptProperties properties;
    private final ObjectMapper objectMapper;

    public boolean supports(MethodParameter returnType, Class converterType) {
        return AnnotationUtil.hasAnnotation((AnnotatedElement)returnType.getMethod(), ApiEncrypt.class);
    }

    @Nullable
    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        byte[] bodyJsonBytes;
        if (body == null) {
            return null;
        }
        CryptoInfoBean cryptoInfoBean = ApiCryptoUtil.getEncryptInfo(returnType);
        if (cryptoInfoBean == null) {
            throw new EncryptBodyFailException();
        }
        try {
            bodyJsonBytes = this.objectMapper.writeValueAsBytes(body);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        String bodyJsonKey = this.properties.getBodyJsonKey();
        if (StrUtil.isBlank((CharSequence)bodyJsonKey)) {
            return ApiCryptoUtil.encryptData(bodyJsonBytes, cryptoInfoBean);
        }
        HashMap<String, String> data = new HashMap<String, String>(2);
        data.put(bodyJsonKey, ApiCryptoUtil.encryptData(bodyJsonBytes, cryptoInfoBean));
        return data;
    }

    public ApiEncryptResponseBodyAdvice(ApiEncryptProperties properties, ObjectMapper objectMapper) {
        this.properties = properties;
        this.objectMapper = objectMapper;
    }
}

