/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.pigx.common.api.encrypt.util;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.Mode;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.symmetric.AES;
import com.pig4cloud.pigx.common.api.encrypt.annotation.decrypt.ApiDecrypt;
import com.pig4cloud.pigx.common.api.encrypt.annotation.encrypt.ApiEncrypt;
import com.pig4cloud.pigx.common.api.encrypt.bean.CryptoInfoBean;
import com.pig4cloud.pigx.common.api.encrypt.core.ISecretKeyResolver;
import com.pig4cloud.pigx.common.api.encrypt.enums.EncryptType;
import com.pig4cloud.pigx.common.api.encrypt.exception.EncryptBodyFailException;
import com.pig4cloud.pigx.common.api.encrypt.exception.EncryptMethodNotFoundException;
import com.pig4cloud.pigx.common.core.util.SpringContextHolder;
import com.pig4cloud.pigx.common.core.util.WebUtils;
import java.lang.reflect.AnnotatedElement;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class ApiCryptoUtil {
    @Nullable
    public static CryptoInfoBean getEncryptInfo(MethodParameter methodParameter) {
        ApiEncrypt encryptBody = (ApiEncrypt)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)methodParameter.getMethod(), ApiEncrypt.class);
        if (encryptBody == null) {
            return null;
        }
        return new CryptoInfoBean(encryptBody.value(), encryptBody.secretKey());
    }

    @Nullable
    public static CryptoInfoBean getDecryptInfo(MethodParameter methodParameter) {
        ApiDecrypt decryptBody = (ApiDecrypt)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)methodParameter.getMethod(), ApiDecrypt.class);
        if (decryptBody == null) {
            return null;
        }
        return new CryptoInfoBean(decryptBody.value(), decryptBody.secretKey());
    }

    public static String encryptData(byte[] jsonData, CryptoInfoBean infoBean) {
        EncryptType type = infoBean.getType();
        if (type == null) {
            throw new EncryptMethodNotFoundException();
        }
        String secretKey = infoBean.getSecretKey();
        if (StrUtil.isBlank((CharSequence)secretKey)) {
            secretKey = ((ISecretKeyResolver)SpringContextHolder.getBean(ISecretKeyResolver.class)).getSecretKey(WebUtils.getRequest(), type);
        }
        Assert.hasText((String)secretKey, (String)((Object)((Object)type) + " key is not configured (\u672a\u914d\u7f6e" + (Object)((Object)type) + ")"));
        if (type == EncryptType.DES) {
            return SecureUtil.des((byte[])secretKey.getBytes(StandardCharsets.UTF_8)).encryptBase64(jsonData);
        }
        if (type == EncryptType.AES) {
            AES aes = new AES(Mode.CFB, Padding.NoPadding, (SecretKey)new SecretKeySpec(secretKey.getBytes(), "AES"), (AlgorithmParameterSpec)new IvParameterSpec(secretKey.getBytes()));
            return aes.encryptBase64(jsonData);
        }
        if (type == EncryptType.RSA) {
            return SecureUtil.rsa((byte[])secretKey.getBytes(StandardCharsets.UTF_8), null).encryptBase64(jsonData, KeyType.PrivateKey);
        }
        throw new EncryptBodyFailException();
    }

    public static byte[] decryptData(byte[] bodyData, CryptoInfoBean infoBean) {
        EncryptType type = infoBean.getType();
        if (type == null) {
            throw new EncryptMethodNotFoundException();
        }
        String secretKey = infoBean.getSecretKey();
        if (StrUtil.isBlank((CharSequence)secretKey)) {
            secretKey = ((ISecretKeyResolver)SpringContextHolder.getBean(ISecretKeyResolver.class)).getSecretKey(WebUtils.getRequest(), type);
        }
        Assert.hasText((String)secretKey, (String)((Object)((Object)type) + " key is not configured (\u672a\u914d\u7f6e" + (Object)((Object)type) + ")"));
        if (type == EncryptType.AES) {
            AES aes = new AES(Mode.CFB, Padding.NoPadding, (SecretKey)new SecretKeySpec(secretKey.getBytes(StandardCharsets.UTF_8), "AES"), (AlgorithmParameterSpec)new IvParameterSpec(secretKey.getBytes(StandardCharsets.UTF_8)));
            return aes.decrypt(StrUtil.str((byte[])bodyData, (Charset)StandardCharsets.UTF_8));
        }
        if (type == EncryptType.DES) {
            return SecureUtil.des((byte[])secretKey.getBytes(StandardCharsets.UTF_8)).decrypt(bodyData);
        }
        if (type == EncryptType.RSA) {
            return SecureUtil.rsa((byte[])secretKey.getBytes(StandardCharsets.UTF_8), null).decrypt(bodyData, KeyType.PrivateKey);
        }
        throw new EncryptMethodNotFoundException();
    }

    private ApiCryptoUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

