/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.pigx.common.idempotent.aspect;

import com.pig4cloud.pigx.common.idempotent.annotation.Idempotent;
import com.pig4cloud.pigx.common.idempotent.exception.IdempotentException;
import com.pig4cloud.pigx.common.idempotent.expression.KeyResolver;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.Redisson;
import org.redisson.api.RMapCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class IdempotentAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdempotentAspect.class);
    private static final ThreadLocal<Map<String, Object>> THREAD_CACHE = ThreadLocal.withInitial(HashMap::new);
    private static final String RMAPCACHE_KEY = "idempotent";
    private static final String KEY = "key";
    private static final String DELKEY = "delKey";
    @Autowired
    private Redisson redisson;
    @Autowired
    private KeyResolver keyResolver;

    @Pointcut(value="@annotation(com.pig4cloud.pigx.common.idempotent.annotation.Idempotent)")
    public void pointCut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before(value="pointCut()")
    public void beforePointCut(JoinPoint joinPoint) {
        String key;
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = requestAttributes.getRequest();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        if (!method.isAnnotationPresent(Idempotent.class)) {
            return;
        }
        Idempotent idempotent = method.getAnnotation(Idempotent.class);
        if (!StringUtils.hasLength((String)idempotent.key())) {
            String url = request.getRequestURL().toString();
            String argString = Arrays.asList(joinPoint.getArgs()).toString();
            key = url + argString;
        } else {
            key = this.keyResolver.resolver(idempotent, joinPoint);
        }
        long expireTime = idempotent.expireTime();
        String info = idempotent.info();
        TimeUnit timeUnit = idempotent.timeUnit();
        boolean delKey = idempotent.delKey();
        RMapCache rMapCache = this.redisson.getMapCache(RMAPCACHE_KEY);
        String value = LocalDateTime.now().toString().replace("T", " ");
        if (null != rMapCache.get((Object)key)) {
            throw new IdempotentException("[idempotent]:" + info);
        }
        IdempotentAspect idempotentAspect = this;
        synchronized (idempotentAspect) {
            Object v1 = rMapCache.putIfAbsent((Object)key, (Object)value, expireTime, timeUnit);
            if (null != v1) {
                throw new IdempotentException("[idempotent]:" + info);
            }
            LOGGER.info("[idempotent]:has stored key={},value={},expireTime={}{},now={}", new Object[]{key, value, expireTime, timeUnit, LocalDateTime.now().toString()});
        }
        Map<String, Object> map = THREAD_CACHE.get();
        map.put(KEY, key);
        map.put(DELKEY, delKey);
    }

    @After(value="pointCut()")
    public void afterPointCut(JoinPoint joinPoint) {
        Map<String, Object> map = THREAD_CACHE.get();
        if (CollectionUtils.isEmpty(map)) {
            return;
        }
        RMapCache mapCache = this.redisson.getMapCache(RMAPCACHE_KEY);
        if (mapCache.size() == 0) {
            return;
        }
        String key = map.get(KEY).toString();
        boolean delKey = (Boolean)map.get(DELKEY);
        if (delKey) {
            mapCache.fastRemove(new Object[]{key});
            LOGGER.info("[idempotent]:has removed key={}", (Object)key);
        }
        THREAD_CACHE.remove();
    }
}

