/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.pigx.common.log.aspect;

import cn.hutool.core.util.StrUtil;
import com.pig4cloud.pigx.common.core.util.KeyStrResolver;
import com.pig4cloud.pigx.common.log.annotation.SysLog;
import com.pig4cloud.pigx.common.log.event.SysLogEvent;
import com.pig4cloud.pigx.common.log.fegin.req.SysLogDTO;
import com.pig4cloud.pigx.common.log.util.LogTypeEnum;
import com.pig4cloud.pigx.common.log.util.SysLogUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.expression.EvaluationContext;

@Aspect
public class SysLogAspect {
    private static final Logger log = LoggerFactory.getLogger(SysLogAspect.class);
    private final ApplicationEventPublisher publisher;
    private final KeyStrResolver tenantKeyStrResolver;

    @Around(value="@annotation(sysLog)")
    public Object around(ProceedingJoinPoint point, SysLog sysLog) {
        Object obj;
        String strClassName = point.getTarget().getClass().getName();
        String strMethodName = point.getSignature().getName();
        log.debug("[\u7c7b\u540d]:{},[\u65b9\u6cd5]:{}", (Object)strClassName, (Object)strMethodName);
        String value = sysLog.value();
        String expression = sysLog.expression();
        if (StrUtil.isNotBlank((CharSequence)expression)) {
            MethodSignature signature = (MethodSignature)point.getSignature();
            EvaluationContext context = SysLogUtils.getContext(point.getArgs(), signature.getMethod());
            try {
                value = SysLogUtils.getValue(context, expression, String.class);
            }
            catch (Exception e) {
                log.error("@SysLog \u89e3\u6790SPEL {} \u5f02\u5e38", (Object)expression);
            }
        }
        SysLogDTO logDTO = SysLogUtils.getSysLog();
        logDTO.setTitle(value);
        Long startTime = System.currentTimeMillis();
        try {
            obj = point.proceed();
        }
        catch (Exception e) {
            logDTO.setLogType(LogTypeEnum.ERROR.getType());
            logDTO.setException(e.getMessage());
            throw e;
        }
        finally {
            Long endTime = System.currentTimeMillis();
            logDTO.setTime(endTime - startTime);
            logDTO.setTenantId(Long.parseLong(this.tenantKeyStrResolver.key()));
            this.publisher.publishEvent((Object)new SysLogEvent(logDTO));
        }
        return obj;
    }

    public SysLogAspect(ApplicationEventPublisher publisher, KeyStrResolver tenantKeyStrResolver) {
        this.publisher = publisher;
        this.tenantKeyStrResolver = tenantKeyStrResolver;
    }
}

