/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.pigx.common.file.local;

import cn.hutool.core.io.FileUtil;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.pig4cloud.pigx.common.file.core.FileProperties;
import com.pig4cloud.pigx.common.file.core.FileTemplate;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class LocalFileTemplate
implements FileTemplate {
    private final FileProperties properties;

    @Override
    public void createBucket(String bucketName) {
        FileUtil.mkdir((String)(this.properties.getLocal().getBasePath() + FileUtil.FILE_SEPARATOR + bucketName));
    }

    @Override
    public List<Bucket> getAllBuckets() {
        return Arrays.stream(FileUtil.ls((String)this.properties.getLocal().getBasePath())).filter(FileUtil::isDirectory).map(dir -> new Bucket(dir.getName())).collect(Collectors.toList());
    }

    @Override
    public void removeBucket(String bucketName) {
        FileUtil.del((String)(this.properties.getLocal().getBasePath() + FileUtil.FILE_SEPARATOR + bucketName));
    }

    @Override
    public void putObject(String bucketName, String objectName, InputStream stream, String contextType) {
        String dir = this.properties.getLocal().getBasePath() + FileUtil.FILE_SEPARATOR + bucketName;
        if (!FileUtil.isDirectory((String)(this.properties.getLocal().getBasePath() + FileUtil.FILE_SEPARATOR + bucketName))) {
            this.createBucket(bucketName);
        }
        File file = FileUtil.file((String)(dir + FileUtil.FILE_SEPARATOR + objectName));
        FileUtil.writeFromStream((InputStream)stream, (File)file);
    }

    @Override
    public S3Object getObject(String bucketName, String objectName) {
        String dir = this.properties.getLocal().getBasePath() + FileUtil.FILE_SEPARATOR + bucketName;
        S3Object s3Object = new S3Object();
        s3Object.setObjectContent((InputStream)FileUtil.getInputStream((String)(dir + FileUtil.FILE_SEPARATOR + objectName)));
        return s3Object;
    }

    @Override
    public void removeObject(String bucketName, String objectName) throws Exception {
        String dir = this.properties.getLocal().getBasePath() + FileUtil.FILE_SEPARATOR + bucketName;
        FileUtil.del((String)(dir + FileUtil.FILE_SEPARATOR + objectName));
    }

    @Override
    public void putObject(String bucketName, String objectName, InputStream stream) throws Exception {
        this.putObject(bucketName, objectName, stream, null);
    }

    @Override
    public List<S3ObjectSummary> getAllObjectsByPrefix(String bucketName, String prefix, boolean recursive) {
        String dir = this.properties.getLocal().getBasePath() + FileUtil.FILE_SEPARATOR + bucketName;
        return Arrays.stream(FileUtil.ls((String)dir)).filter(file -> file.getName().startsWith(prefix)).map(file -> {
            S3ObjectSummary summary = new S3ObjectSummary();
            summary.setKey(file.getName());
            return new S3ObjectSummary();
        }).collect(Collectors.toList());
    }

    public LocalFileTemplate(FileProperties properties) {
        this.properties = properties;
    }
}

