/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.pigx.common.file.oss;

import com.pig4cloud.pigx.common.file.core.FileProperties;
import com.pig4cloud.pigx.common.file.core.FileTemplate;
import com.pig4cloud.pigx.common.file.oss.http.OssEndpoint;
import com.pig4cloud.pigx.common.file.oss.service.OssTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

public class OssAutoConfiguration {
    private final FileProperties properties;

    @Bean
    @Primary
    @ConditionalOnMissingBean(value={OssTemplate.class})
    @ConditionalOnProperty(name={"file.oss.enable"}, havingValue="true")
    public FileTemplate ossTemplate() {
        return new OssTemplate(this.properties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"file.oss.info"}, havingValue="true")
    public OssEndpoint ossEndpoint(OssTemplate template) {
        return new OssEndpoint(template);
    }

    public OssAutoConfiguration(FileProperties properties) {
        this.properties = properties;
    }
}

