/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.pigx.common.file.oss.http;

import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.pig4cloud.pigx.common.file.oss.service.OssTemplate;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/oss"})
@ConditionalOnProperty(name={"file.oss.info"}, havingValue="true")
public class OssEndpoint {
    private final OssTemplate template;

    @PostMapping(value={"/bucket/{bucketName}"})
    public Bucket createBucker(@PathVariable String bucketName) {
        this.template.createBucket(bucketName);
        return this.template.getBucket(bucketName).get();
    }

    @GetMapping(value={"/bucket"})
    public List<Bucket> getBuckets() {
        return this.template.getAllBuckets();
    }

    @GetMapping(value={"/bucket/{bucketName}"})
    public Bucket getBucket(@PathVariable String bucketName) {
        return this.template.getBucket(bucketName).orElseThrow(() -> new IllegalArgumentException("Bucket Name not found!"));
    }

    @DeleteMapping(value={"/bucket/{bucketName}"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void deleteBucket(@PathVariable String bucketName) {
        this.template.removeBucket(bucketName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/object/{bucketName}"})
    public S3Object createObject(@RequestBody MultipartFile object, @PathVariable String bucketName) {
        S3Object s3Object;
        block6: {
            String name = object.getOriginalFilename();
            InputStream inputStream = object.getInputStream();
            try {
                this.template.putObject(bucketName, name, inputStream, object.getSize(), object.getContentType());
                s3Object = this.template.getObjectInfo(bucketName, name);
                if (Collections.singletonList(inputStream).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(inputStream).get(0) != null) {
                    inputStream.close();
                }
                throw throwable;
            }
            inputStream.close();
        }
        return s3Object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/object/{bucketName}/{objectName}"})
    public S3Object createObject(@RequestBody MultipartFile object, @PathVariable String bucketName, @PathVariable String objectName) {
        S3Object s3Object;
        block6: {
            InputStream inputStream = object.getInputStream();
            try {
                this.template.putObject(bucketName, objectName, inputStream, object.getSize(), object.getContentType());
                s3Object = this.template.getObjectInfo(bucketName, objectName);
                if (Collections.singletonList(inputStream).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(inputStream).get(0) != null) {
                    inputStream.close();
                }
                throw throwable;
            }
            inputStream.close();
        }
        return s3Object;
    }

    @GetMapping(value={"/object/{bucketName}/{objectName}"})
    public List<S3ObjectSummary> filterObject(@PathVariable String bucketName, @PathVariable String objectName) {
        return this.template.getAllObjectsByPrefix(bucketName, objectName, true);
    }

    @GetMapping(value={"/object/{bucketName}/{objectName}/{expires}"})
    public Map<String, Object> getObject(@PathVariable String bucketName, @PathVariable String objectName, @PathVariable Integer expires) {
        HashMap<String, Object> responseBody = new HashMap<String, Object>(8);
        responseBody.put("bucket", bucketName);
        responseBody.put("object", objectName);
        responseBody.put("url", this.template.getObjectURL(bucketName, objectName, expires));
        responseBody.put("expires", expires);
        return responseBody;
    }

    @ResponseStatus(value=HttpStatus.ACCEPTED)
    @DeleteMapping(value={"/object/{bucketName}/{objectName}/"})
    public void deleteObject(@PathVariable String bucketName, @PathVariable String objectName) {
        this.template.removeObject(bucketName, objectName);
    }

    public OssEndpoint(OssTemplate template) {
        this.template = template;
    }
}

