/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.pigx.common.file.oss.service;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.util.IOUtils;
import com.pig4cloud.pigx.common.file.core.FileProperties;
import com.pig4cloud.pigx.common.file.core.FileTemplate;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.InitializingBean;

public class OssTemplate
implements InitializingBean,
FileTemplate {
    private final FileProperties properties;
    private AmazonS3 amazonS3;

    @Override
    public void createBucket(String bucketName) {
        if (!this.amazonS3.doesBucketExistV2(bucketName)) {
            this.amazonS3.createBucket(bucketName);
        }
    }

    @Override
    public List<Bucket> getAllBuckets() {
        return this.amazonS3.listBuckets();
    }

    public Optional<Bucket> getBucket(String bucketName) {
        return this.amazonS3.listBuckets().stream().filter(b -> b.getName().equals(bucketName)).findFirst();
    }

    @Override
    public void removeBucket(String bucketName) {
        this.amazonS3.deleteBucket(bucketName);
    }

    @Override
    public List<S3ObjectSummary> getAllObjectsByPrefix(String bucketName, String prefix, boolean recursive) {
        ObjectListing objectListing = this.amazonS3.listObjects(bucketName, prefix);
        return new ArrayList<S3ObjectSummary>(objectListing.getObjectSummaries());
    }

    public String getObjectURL(String bucketName, String objectName, Integer expires) {
        Date date = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, expires);
        URL url = this.amazonS3.generatePresignedUrl(bucketName, objectName, calendar.getTime());
        return url.toString();
    }

    @Override
    public S3Object getObject(String bucketName, String objectName) {
        return this.amazonS3.getObject(bucketName, objectName);
    }

    @Override
    public void putObject(String bucketName, String objectName, InputStream stream) throws Exception {
        this.putObject(bucketName, objectName, stream, stream.available(), "application/octet-stream");
    }

    @Override
    public void putObject(String bucketName, String objectName, InputStream stream, String contextType) throws Exception {
        this.putObject(bucketName, objectName, stream, stream.available(), contextType);
    }

    public PutObjectResult putObject(String bucketName, String objectName, InputStream stream, long size, String contextType) throws Exception {
        byte[] bytes = IOUtils.toByteArray((InputStream)stream);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentLength(size);
        objectMetadata.setContentType(contextType);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        return this.amazonS3.putObject(bucketName, objectName, (InputStream)byteArrayInputStream, objectMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S3Object getObjectInfo(String bucketName, String objectName) throws Exception {
        S3Object object = this.amazonS3.getObject(bucketName, objectName);
        try {
            S3Object s3Object = object;
            return s3Object;
        }
        finally {
            if (Collections.singletonList(object).get(0) != null) {
                object.close();
            }
        }
    }

    @Override
    public void removeObject(String bucketName, String objectName) throws Exception {
        this.amazonS3.deleteObject(bucketName, objectName);
    }

    @Override
    public void afterPropertiesSet() {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setMaxConnections(this.properties.getOss().getMaxConnections().intValue());
        AwsClientBuilder.EndpointConfiguration endpointConfiguration = new AwsClientBuilder.EndpointConfiguration(this.properties.getOss().getEndpoint(), this.properties.getOss().getRegion());
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(this.properties.getOss().getAccessKey(), this.properties.getOss().getSecretKey());
        AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
        this.amazonS3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withEndpointConfiguration(endpointConfiguration)).withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)awsCredentialsProvider)).disableChunkedEncoding()).withPathStyleAccessEnabled(this.properties.getOss().getPathStyleAccess())).build();
    }

    public OssTemplate(FileProperties properties) {
        this.properties = properties;
    }
}

