/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.pigx.common.sequence.builder;

import com.pig4cloud.pigx.common.sequence.builder.SeqBuilder;
import com.pig4cloud.pigx.common.sequence.range.BizName;
import com.pig4cloud.pigx.common.sequence.range.PrefixName;
import com.pig4cloud.pigx.common.sequence.range.impl.db.DbSeqRangeMgr;
import com.pig4cloud.pigx.common.sequence.sequence.Sequence;
import com.pig4cloud.pigx.common.sequence.sequence.impl.DefaultRangeSequence;
import javax.sql.DataSource;

public class DbSeqBuilder
implements SeqBuilder {
    private DataSource dataSource;
    private BizName bizName;
    private PrefixName prefixName;
    private String tableName = "sequence";
    private int retryTimes = 100;
    private int step = 1000;
    private long stepStart = 0L;

    public static DbSeqBuilder create() {
        DbSeqBuilder builder = new DbSeqBuilder();
        return builder;
    }

    @Override
    public Sequence build() {
        DbSeqRangeMgr dbSeqRangeMgr = new DbSeqRangeMgr();
        dbSeqRangeMgr.setTableName(this.tableName);
        dbSeqRangeMgr.setRetryTimes(this.retryTimes);
        dbSeqRangeMgr.setStep(this.step);
        dbSeqRangeMgr.setStepStart(this.stepStart);
        dbSeqRangeMgr.init();
        DefaultRangeSequence sequence = new DefaultRangeSequence();
        sequence.setName(this.bizName);
        sequence.setPrefixName(this.prefixName);
        sequence.setSeqRangeMgr(dbSeqRangeMgr);
        return sequence;
    }

    public DbSeqBuilder dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public DbSeqBuilder tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public DbSeqBuilder retryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
        return this;
    }

    public DbSeqBuilder step(int step) {
        this.step = step;
        return this;
    }

    public DbSeqBuilder bizName(BizName bizName) {
        this.bizName = bizName;
        return this;
    }

    public DbSeqBuilder stepStart(long stepStart) {
        this.stepStart = stepStart;
        return this;
    }

    public DbSeqBuilder prefixName(PrefixName prefixName) {
        this.prefixName = prefixName;
        return this;
    }
}

