/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.pigx.common.sequence.range.impl.db;

import cn.hutool.core.util.RandomUtil;
import com.pig4cloud.pigx.common.sequence.exception.SeqException;
import com.pig4cloud.pigx.common.sequence.range.impl.db.SequenceTable;
import java.time.LocalDateTime;
import java.util.Objects;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.entity.DataRow;
import org.anyline.proxy.ServiceProxy;
import org.anyline.service.AnylineService;

abstract class BaseDbHelper {
    private static final long DELTA = 100000000L;

    BaseDbHelper() {
    }

    static boolean updateRange(String tableName, Long newValue, Long oldValue, String name) {
        AnylineService service = ServiceProxy.service();
        SequenceTable sequenceTable = new SequenceTable();
        sequenceTable.setValue(newValue);
        sequenceTable.setGmtModified(LocalDateTime.now());
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.and("value", (Object)oldValue);
        return service.update(tableName, (Object)sequenceTable, (ConfigStore)configs, new String[0]) > 0L;
    }

    static Long selectRange(String tableName, String name, long stepStart) {
        AnylineService service = ServiceProxy.service();
        DataRow dataRow = service.query(tableName, new String[]{"name:" + name});
        if (Objects.isNull(dataRow)) {
            SequenceTable sequenceTable = new SequenceTable();
            sequenceTable.setId(RandomUtil.getSecureRandom().nextLong());
            sequenceTable.setName(name);
            sequenceTable.setValue(stepStart);
            sequenceTable.setGmtCreate(LocalDateTime.now());
            sequenceTable.setGmtModified(LocalDateTime.now());
            service.insert(tableName, (Object)sequenceTable, new String[0]);
            return stepStart;
        }
        long oldValue = dataRow.getLong("value");
        if (oldValue < 0L) {
            String msg = "Sequence value cannot be less than zero, value = " + oldValue + ", please check table sequence" + tableName;
            throw new SeqException(msg);
        }
        if (oldValue > 9223372036754775807L) {
            String msg = "Sequence value overflow, value = " + oldValue + ", please check table sequence" + tableName;
            throw new SeqException(msg);
        }
        return oldValue;
    }
}

