/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.pigx.common.sequence.range.impl.db;

import cn.hutool.core.thread.ThreadUtil;
import com.pig4cloud.pigx.common.sequence.exception.SeqException;
import com.pig4cloud.pigx.common.sequence.range.SeqRange;
import com.pig4cloud.pigx.common.sequence.range.SeqRangeMgr;
import com.pig4cloud.pigx.common.sequence.range.impl.db.BaseDbHelper;
import java.util.concurrent.TimeUnit;

public class DbSeqRangeMgr
implements SeqRangeMgr {
    private int step = 1000;
    private long stepStart = 0L;
    private int retryTimes = 100;
    private String tableName = "range";

    @Override
    public SeqRange nextRange(String name) throws SeqException {
        if (this.isEmpty(name)) {
            throw new SecurityException("[DbSeqRangeMgr-nextRange] name is empty.");
        }
        for (int i = 0; i < this.getRetryTimes(); ++i) {
            Long oldValue = BaseDbHelper.selectRange(this.getRealTableName(), name, this.getStepStart());
            if (null == oldValue) continue;
            Long newValue = oldValue + (long)this.getStep();
            if (BaseDbHelper.updateRange(this.getRealTableName(), newValue, oldValue, name)) {
                return new SeqRange(oldValue + 1L, newValue);
            }
            ThreadUtil.sleep((Number)1, (TimeUnit)TimeUnit.SECONDS);
        }
        throw new SeqException("Retried too many times, retryTimes = " + this.getRetryTimes());
    }

    @Override
    public void init() {
        this.checkParam();
    }

    private boolean isEmpty(String str) {
        return null == str || str.trim().isEmpty();
    }

    private String getRealTableName() {
        return this.getTableName();
    }

    private void checkParam() {
        if (this.step <= 0) {
            throw new SecurityException("[DbSeqRangeMgr-checkParam] step must greater than 0.");
        }
        if (this.stepStart < 0L) {
            throw new SecurityException("[DbSeqRangeMgr-setStepStart] stepStart < 0.");
        }
        if (this.retryTimes <= 0) {
            throw new SecurityException("[DbSeqRangeMgr-setRetryTimes] retryTimes must greater than 0.");
        }
        if (this.isEmpty(this.tableName)) {
            throw new SecurityException("[DbSeqRangeMgr-setTableName] tableName is empty.");
        }
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public long getStepStart() {
        return this.stepStart;
    }

    public void setStepStart(long stepStart) {
        this.stepStart = stepStart;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

