/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.pigx.common.sequence.range.impl.redis;

import com.pig4cloud.pigx.common.sequence.exception.SeqException;
import com.pig4cloud.pigx.common.sequence.range.SeqRange;
import com.pig4cloud.pigx.common.sequence.range.SeqRangeMgr;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisSeqRangeMgr
implements SeqRangeMgr {
    private static final String KEY_PREFIX = "x_sequence_";
    private StringRedisTemplate stringRedisTemplate;
    private int step = 1000;
    private long stepStart = 0L;
    private volatile boolean keyAlreadyExist;

    @Override
    public SeqRange nextRange(String name) throws SeqException {
        if (!this.keyAlreadyExist) {
            if (Boolean.FALSE.equals(this.stringRedisTemplate.hasKey((Object)this.getRealKey(name)))) {
                this.stringRedisTemplate.opsForValue().setIfAbsent((Object)this.getRealKey(name), (Object)String.valueOf(this.stepStart));
            }
            this.keyAlreadyExist = true;
        }
        Long max = this.stringRedisTemplate.opsForValue().increment((Object)this.getRealKey(name), (long)this.step);
        Long min = max - (long)this.step + 1L;
        return new SeqRange(min, max);
    }

    private String getRealKey(String name) {
        return KEY_PREFIX + name;
    }

    private boolean isEmpty(String str) {
        return null == str || str.trim().length() == 0;
    }

    public long getStepStart() {
        return this.stepStart;
    }

    public void setStepStart(long stepStart) {
        this.stepStart = stepStart;
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }

    public void setStringRedisTemplate(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }
}

