/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.pigx.common.sequence.sequence.impl;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.format.DatePrinter;
import cn.hutool.core.util.StrUtil;
import com.pig4cloud.pigx.common.sequence.exception.SeqException;
import com.pig4cloud.pigx.common.sequence.range.BizName;
import com.pig4cloud.pigx.common.sequence.range.PrefixName;
import com.pig4cloud.pigx.common.sequence.range.SeqRange;
import com.pig4cloud.pigx.common.sequence.range.SeqRangeMgr;
import com.pig4cloud.pigx.common.sequence.sequence.RangeSequence;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DefaultRangeSequence
implements RangeSequence {
    private final Lock lock = new ReentrantLock();
    private SeqRangeMgr seqRangeMgr;
    private volatile SeqRange currentRange;
    private static Map<String, SeqRange> seqRangeMap = new ConcurrentHashMap<String, SeqRange>(8);
    private BizName bizName;
    private PrefixName prefixName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long nextValue() throws SeqException {
        long value;
        String name = this.bizName.create();
        this.currentRange = seqRangeMap.get(name);
        if (null == this.currentRange) {
            this.lock.lock();
            try {
                if (null == this.currentRange) {
                    this.currentRange = this.seqRangeMgr.nextRange(name);
                    seqRangeMap.put(name, this.currentRange);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if ((value = this.currentRange.getAndIncrement()) == -1L) {
            this.lock.lock();
            try {
                while (true) {
                    if (this.currentRange.isOver()) {
                        this.currentRange = this.seqRangeMgr.nextRange(name);
                        seqRangeMap.put(name, this.currentRange);
                    }
                    if ((value = this.currentRange.getAndIncrement()) == -1L) {
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if (value < 0L) {
            throw new SeqException("Sequence value overflow, value = " + value);
        }
        return value;
    }

    @Override
    public String nextNo() throws SeqException {
        String s = this.prefixName.create();
        if (StrUtil.isEmpty((CharSequence)s)) {
            return String.format("%s%05d", DateUtil.format((Date)new Date(), (DatePrinter)DatePattern.PURE_DATE_FORMAT), this.nextValue());
        }
        return String.format("%s%s%05d", s, DateUtil.format((Date)new Date(), (DatePrinter)DatePattern.PURE_DATE_FORMAT), this.nextValue());
    }

    @Override
    public void setSeqRangeMgr(SeqRangeMgr seqRangeMgr) {
        this.seqRangeMgr = seqRangeMgr;
    }

    @Override
    public void setName(BizName name) {
        this.bizName = name;
    }

    @Override
    public void setPrefixName(PrefixName prefixName) {
        this.prefixName = prefixName;
    }
}

