/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.pigx.common.sequence.sequence.impl;

import com.pig4cloud.pigx.common.sequence.exception.SeqException;
import com.pig4cloud.pigx.common.sequence.sequence.Sequence;

public class SnowflakeSequence
implements Sequence {
    private final long twepoch = 1514736000000L;
    private final long workerIdBits = 5L;
    private final long datacenterIdBits = 5L;
    private final long maxWorkerId = 31L;
    private final long maxDatacenterId = 31L;
    private final long sequenceBits = 12L;
    private final long workerIdShift = 12L;
    private final long datacenterIdShift = 17L;
    private final long timestampLeftShift = 22L;
    private final long sequenceMask = 4095L;
    private long workerId;
    private long datacenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    @Override
    public synchronized long nextValue() throws SeqException {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new SeqException("[SnowflakeSequence-nextValue] \u5f53\u524d\u65f6\u95f4\u5c0f\u4e8e\u4e0a\u6b21\u751f\u6210\u5e8f\u5217\u53f7\u7684\u65f6\u95f4\uff0c\u65f6\u95f4\u88ab\u56de\u9000\u4e86\uff0c\u8bf7\u786e\u8ba4\u670d\u52a1\u5668\u65f6\u95f4\u7684\u8bbe\u7f6e.");
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1514736000000L << 22 | this.datacenterId << 17 | this.workerId << 12 | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    public void setWorkerId(long workerId) {
        if (workerId > 31L) {
            throw new SeqException("[SnowflakeSequence-setWorkerId] workerId \u4e0d\u80fd\u5927\u4e8e31.");
        }
        this.workerId = workerId;
    }

    public void setDatacenterId(long datacenterId) {
        if (datacenterId > 31L) {
            throw new SeqException("[SnowflakeSequence-setDatacenterId] datacenterId \u4e0d\u80fd\u5927\u4e8e31.");
        }
        this.datacenterId = datacenterId;
    }

    @Override
    public String nextNo() throws SeqException {
        return String.valueOf(this.nextValue());
    }
}

