/*
 * Decompiled with CFR 0.152.
 */
package cn.com.twoke.http.annotation.creator;

import cn.com.twoke.http.annotation.Param;
import cn.com.twoke.http.config.ParamData;
import cn.com.twoke.http.exp.HttpSenderException;
import cn.com.twoke.http.type.ParamPosition;
import cn.com.twoke.http.type.RequestMethod;
import java.lang.annotation.Annotation;
import java.util.Objects;

public final class ParamsCreator {
    private ParamsCreator() {
    }

    public static ParamsCreator build() {
        return new ParamsCreator();
    }

    public String create(RequestMethod method, String url, Annotation[][] parameterAnnotations, ParamData params, ParamData data, Object[] args, ParamData<String> config) {
        block7: for (int i = 0; Objects.nonNull(args) && i < args.length; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            Object value = args[i];
            if (annotations.length != 1) {
                throw new HttpSenderException("Request");
            }
            Annotation annotation = annotations[0];
            if (!(annotation instanceof Param)) continue;
            Param paramAnnotation = (Param)annotation;
            String name = paramAnnotation.name();
            ParamPosition position = paramAnnotation.position();
            switch (position) {
                case PATH: {
                    String pathKey = "{" + name + "}";
                    if (url.contains(pathKey)) {
                        url = url.replace(pathKey, value.toString());
                        continue block7;
                    }
                    throw new HttpSenderException(url + " \u4e0d\u5305\u542b\u5730\u5740\u53c2\u6570:" + pathKey);
                }
                case HEADER: {
                    config.putData(name, value.toString());
                    continue block7;
                }
                case URL: {
                    params.putData(name, value);
                    continue block7;
                }
                case BODY: {
                    data.putData(name, value);
                    continue block7;
                }
                case DEFAULT: {
                    this.dispatchDefault(method, params, data, value, name);
                }
            }
        }
        return url;
    }

    private void dispatchDefault(RequestMethod method, ParamData params, ParamData data, Object value, String name) {
        if (RequestMethod.GET.equals((Object)method)) {
            params.putData(name, value);
        } else if (RequestMethod.POST.equals((Object)method)) {
            data.putData(name, value);
        }
    }
}

