/*
 * Decompiled with CFR 0.152.
 */
package cn.com.twoke.http.module;

import cn.com.twoke.http.IHttpSender;
import cn.com.twoke.http.config.RequestConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHttpSender
implements IHttpSender {
    private static final Logger log = LoggerFactory.getLogger(SimpleHttpSender.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doGet(String url, String param, Map<String, String> config) {
        StringBuilder result = new StringBuilder();
        BufferedReader in = null;
        try {
            String line;
            String urlNameString = this.withParams(url, param);
            log.info("doGet - {}", (Object)urlNameString);
            URL realUrl = new URL(urlNameString);
            URLConnection conn = realUrl.openConnection();
            this.withConfig(conn, RequestConfig.doGetConfig);
            this.withConfig(conn, config);
            conn.connect();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
            log.info("recv - {}", (Object)result);
        }
        catch (ConnectException e) {
            log.error("\u8c03\u7528HttpUtils.sendGet ConnectException, url=" + url + ",param=" + param, (Throwable)e);
        }
        catch (SocketTimeoutException e) {
            log.error("\u8c03\u7528HttpUtils.sendGet SocketTimeoutException, url=" + url + ",param=" + param, (Throwable)e);
        }
        catch (IOException e) {
            log.error("\u8c03\u7528HttpUtils.sendGet IOException, url=" + url + ",param=" + param, (Throwable)e);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528HttpsUtil.sendGet Exception, url=" + url + ",param=" + param, (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ex) {
                log.error("\u8c03\u7528in.close Exception, url=" + url + ",param=" + param, (Throwable)ex);
            }
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doPost(String url, String param, String data, Map<String, String> config) {
        PrintWriter out = null;
        BufferedReader in = null;
        StringBuilder result = new StringBuilder();
        try {
            String line;
            String urlNameString = this.withParams(url, param);
            log.info("doPost - {}", (Object)urlNameString);
            URL realUrl = new URL(urlNameString);
            URLConnection conn = realUrl.openConnection();
            this.withConfig(conn, RequestConfig.doPostConfig);
            this.withConfig(conn, config);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new PrintWriter(conn.getOutputStream());
            out.print(data);
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
            log.info("recv - {}", (Object)result);
        }
        catch (ConnectException e) {
            log.error("\u8c03\u7528HttpUtils.sendPost ConnectException, url=" + url + ",param=" + param, (Throwable)e);
        }
        catch (SocketTimeoutException e) {
            log.error("\u8c03\u7528HttpUtils.sendPost SocketTimeoutException, url=" + url + ",param=" + param, (Throwable)e);
        }
        catch (IOException e) {
            log.error("\u8c03\u7528HttpUtils.sendPost IOException, url=" + url + ",param=" + param, (Throwable)e);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528HttpsUtil.sendPost Exception, url=" + url + ",param=" + param, (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                log.error("\u8c03\u7528in.close Exception, url=" + url + ",param=" + param, (Throwable)ex);
            }
        }
        return result.toString();
    }

    @Override
    public String doPost(String url, Map<String, Object> params, Map<String, Object> data, Map<String, String> config) {
        return this.doPost(url, this.createParams(params), this.createParams(data), config);
    }

    @Override
    public String doGet(String url, Map<String, Object> data, Map<String, String> config) {
        return this.doGet(url, this.createParams(data), config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doPostByByte(String url, byte[] param, Map<String, String> config) {
        PrintWriter out = null;
        BufferedReader in = null;
        StringBuilder result = new StringBuilder();
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection conn = realUrl.openConnection();
            this.withConfig(conn, RequestConfig.doPostByteConfig);
            this.withConfig(conn, config);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new PrintWriter(conn.getOutputStream());
            out.print(param);
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
            log.info("recv - {}", (Object)result);
        }
        catch (ConnectException e) {
            log.error("\u8c03\u7528HttpUtils.sendPost ConnectException, url=" + url + ",param=" + param, (Throwable)e);
        }
        catch (SocketTimeoutException e) {
            log.error("\u8c03\u7528HttpUtils.sendPost SocketTimeoutException, url=" + url + ",param=" + param, (Throwable)e);
        }
        catch (IOException e) {
            log.error("\u8c03\u7528HttpUtils.sendPost IOException, url=" + url + ",param=" + param, (Throwable)e);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528HttpsUtil.sendPost Exception, url=" + url + ",param=" + param, (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                log.error("\u8c03\u7528in.close Exception, url=" + url + ",param=" + param, (Throwable)ex);
            }
        }
        return result.toString();
    }

    @Override
    public String doPostSSL(String url, String param, Map<String, String> config) {
        StringBuilder result = new StringBuilder();
        String urlNameString = this.withParams(url, param);
        try {
            log.info("doPostSSL - {}", (Object)urlNameString);
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, new TrustManager[]{new TrustAnyTrustManager()}, new SecureRandom());
            URL console = new URL(urlNameString);
            HttpsURLConnection conn = (HttpsURLConnection)console.openConnection();
            this.withConfig(conn, RequestConfig.doPostSSLConfig);
            this.withConfig(conn, config);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setSSLSocketFactory(sc.getSocketFactory());
            conn.setHostnameVerifier(new TrustAnyHostnameVerifier());
            conn.connect();
            InputStream is = conn.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String ret = "";
            while ((ret = br.readLine()) != null) {
                if (ret == null || ret.trim().equals("")) continue;
                result.append(new String(ret.getBytes("ISO-8859-1"), "utf-8"));
            }
            log.info("recv - {}", (Object)result);
            conn.disconnect();
            br.close();
        }
        catch (ConnectException e) {
            log.error("\u8c03\u7528HttpUtils.sendSSLPost ConnectException, url=" + url + ",param=" + param, (Throwable)e);
        }
        catch (SocketTimeoutException e) {
            log.error("\u8c03\u7528HttpUtils.sendSSLPost SocketTimeoutException, url=" + url + ",param=" + param, (Throwable)e);
        }
        catch (IOException e) {
            log.error("\u8c03\u7528HttpUtils.sendSSLPost IOException, url=" + url + ",param=" + param, (Throwable)e);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528HttpsUtil.sendSSLPost Exception, url=" + url + ",param=" + param, (Throwable)e);
        }
        return result.toString();
    }

    private void withConfig(URLConnection conn, Map<String, String> config) {
        if (Objects.isNull(config) || config.isEmpty()) {
            return;
        }
        config.forEach((key, value) -> conn.setRequestProperty((String)key, (String)value));
    }

    private String createParams(Map<String, Object> data) {
        if (data.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        data.forEach((key, value) -> sb.append(key + "=" + value + "&"));
        return sb.substring(0, sb.length() - 1);
    }

    private String withParams(String url, String param) {
        if (!"".equals(param)) {
            return url + "?" + param;
        }
        return url;
    }

    private static class TrustAnyHostnameVerifier
    implements HostnameVerifier {
        private TrustAnyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class TrustAnyTrustManager
    implements X509TrustManager {
        private TrustAnyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

