/*
 * Decompiled with CFR 0.152.
 */
package cn.com.twoke.http.annotation.creator;

import cn.com.twoke.http.annotation.Param;
import cn.com.twoke.http.config.ParamData;
import cn.com.twoke.http.exp.HttpFaceException;
import cn.com.twoke.http.type.ParamPosition;
import cn.com.twoke.http.type.RequestMethod;
import java.lang.annotation.Annotation;
import java.util.Objects;

public final class ParamsCreator {
    private ParamsCreator() {
    }

    public static ParamsCreator build() {
        return new ParamsCreator();
    }

    public String create(RequestMethod method, String url, Annotation[][] parameterAnnotations, ParamData params, ParamData data, Object[] args, ParamData<String> config) {
        for (int i = 0; Objects.nonNull(args) && i < args.length; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            Object value = args[i];
            if (annotations.length != 1) {
                throw new HttpFaceException("\u63a5\u53e3\u65b9\u6cd5\u53c2\u6570\u9700\u8981\u6dfb\u52a0@Param or @Data \u6ce8\u89e3\u6807\u8bc6\u53c2\u6570");
            }
            Annotation annotation = annotations[0];
            if (!(annotation instanceof Param)) continue;
            Param paramAnnotation = (Param)annotation;
            String name = paramAnnotation.name();
            ParamPosition position = paramAnnotation.position();
            url = this.loadRequestConfig(method, url, params, data, config, value, name, position);
        }
        return url;
    }

    private String loadRequestConfig(RequestMethod method, String url, ParamData params, ParamData data, ParamData<String> config, Object value, String name, ParamPosition position) {
        switch (position) {
            case PATH: {
                String pathKey = "{" + name + "}";
                if (url.contains(pathKey)) {
                    url = url.replace(pathKey, value.toString());
                    break;
                }
                throw new HttpFaceException(url + " \u4e0d\u5305\u542b\u5730\u5740\u53c2\u6570:" + pathKey);
            }
            case HEADER: {
                config.putData(name, value.toString());
                break;
            }
            case URL: {
                params.putData(name, value);
                break;
            }
            case BODY: {
                data.putData(name, value);
                break;
            }
            case DEFAULT: {
                this.dispatchDefault(method, params, data, value, name);
            }
        }
        return url;
    }

    private void dispatchDefault(RequestMethod method, ParamData params, ParamData data, Object value, String name) {
        if (RequestMethod.GET.equals((Object)method)) {
            params.putData(name, value);
        } else if (RequestMethod.POST.equals((Object)method)) {
            data.putData(name, value);
        }
    }
}

