/*
 * Decompiled with CFR 0.152.
 */
package cn.com.twoke.http.annotation.creator;

import cn.com.twoke.http.exp.HttpFaceException;
import cn.com.twoke.http.type.ReturnType;
import cn.com.twoke.http.utils.XmlUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.dom4j.Document;

public final class ReturnCreator {
    private ReturnCreator() {
    }

    public static ReturnCreator build() {
        return new ReturnCreator();
    }

    public Object create(String result, Class<?> returnClass, ReturnType returnType) {
        if (returnClass.equals(String.class)) {
            return result;
        }
        if (ReturnType.JSON.equals((Object)returnType)) {
            return this.parseJson(result, returnClass);
        }
        if (ReturnType.XML.equals((Object)returnType)) {
            return this.parseXml(result, returnClass);
        }
        return null;
    }

    private Object parseJson(String result, Class<?> returnClass) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            if (returnClass.equals(JsonNode.class)) {
                return objectMapper.readTree(result);
            }
            return objectMapper.readValue(result, returnClass);
        }
        catch (JsonProcessingException e) {
            throw new HttpFaceException("\u8bf7\u6c42\u7ed3\u679c\u8f6c\u5316\u5931\u8d25\uff01").setResult(result);
        }
    }

    private Object parseXml(String result, Class<?> returnClass) {
        try {
            if (returnClass.equals(Document.class)) {
                return XmlUtil.xmlToDocument(result);
            }
            return XmlUtil.xmlToBean(result, returnClass);
        }
        catch (IOException e) {
            throw new HttpFaceException("\u8bf7\u6c42\u7ed3\u679c\u8f6c\u5316\u5931\u8d25\uff01").setResult(result);
        }
    }
}

