/*
 * Decompiled with CFR 0.152.
 */
package cn.com.twoke.http.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlUtil {
    private static final Logger log = LoggerFactory.getLogger(XmlUtil.class);
    public static XmlMapper xmlMapper = new XmlMapper();

    public static <T> T xmlToBean(String input, Class<T> cls) throws IOException {
        return (T)xmlMapper.readValue(input, cls);
    }

    public static String beanToXmlStr(Object input) throws IOException {
        String xmlStr = xmlMapper.writeValueAsString(input);
        return xmlStr;
    }

    public static Map<String, Object> beanToXmlStrToMap(Object input) throws IOException {
        String xmlStr = xmlMapper.writeValueAsString(input);
        Map map = (Map)xmlMapper.readValue(xmlStr, Map.class);
        return map;
    }

    public static String xmlFileToString(String fileName) {
        try {
            SAXReader saxReader = new SAXReader();
            Document tempDocument = saxReader.read(fileName);
            return tempDocument.asXML();
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Document xmlToDocument(String xml) {
        try {
            SAXReader saxReader = new SAXReader();
            ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
            return saxReader.read((InputStream)in);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void strToXmlFile(String str, File fileName) throws IOException {
        SAXReader saxReader = new SAXReader();
        try (XMLWriter writer = null;){
            Document document = saxReader.read((InputStream)new ByteArrayInputStream(str.getBytes("UTF-8")));
            OutputFormat format = OutputFormat.createPrettyPrint();
            writer = new XMLWriter((Writer)new FileWriter(fileName), format);
            writer.write(document);
        }
    }

    static {
        xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        xmlMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        xmlMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        xmlMapper.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
        xmlMapper.enable(new MapperFeature[]{MapperFeature.USE_STD_BEAN_NAMING});
    }
}

