/*
 * Decompiled with CFR 0.152.
 */
package cn.com.twoke.http.config;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;

public class RequestFunction {
    private Method method;
    private Object[] args;

    public String getMethodName() {
        String methodName = this.method.getName();
        String returnName = this.method.getReturnType().getName();
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        StringBuilder params = new StringBuilder();
        Arrays.asList(parameterTypes).forEach(item -> params.append(item.getName() + ","));
        return MessageFormat.format("{0} {1}({2})", returnName, methodName, params.substring(0, params.length()));
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public RequestFunction setMethod(Method method) {
        this.method = method;
        return this;
    }

    public RequestFunction setArgs(Object[] args) {
        this.args = args;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestFunction)) {
            return false;
        }
        RequestFunction other = (RequestFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Method this$method = this.getMethod();
        Method other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
            return false;
        }
        return Arrays.deepEquals(this.getArgs(), other.getArgs());
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getArgs());
        return result;
    }

    public String toString() {
        return "RequestFunction(method=" + this.getMethod() + ", args=" + Arrays.deepToString(this.getArgs()) + ")";
    }

    public RequestFunction(Method method, Object[] args) {
        this.method = method;
        this.args = args;
    }

    public RequestFunction() {
    }
}

