/*
 * Decompiled with CFR 0.152.
 */
package cn.com.twoke.http.config;

import cn.com.twoke.http.annotation.Header;
import cn.com.twoke.http.annotation.ServiceClient;
import cn.com.twoke.http.config.ParamData;
import cn.com.twoke.http.utils.FnUtil;
import java.util.Objects;

public class ServiceContext {
    private String base;
    private ParamData<String> headers = ParamData.newParam();

    private ServiceContext() {
    }

    private ServiceContext(String base, ParamData<String> headers) {
        this.base = base;
        this.headers = headers;
    }

    public static ServiceContext create(String base, ParamData<String> headers) {
        return new ServiceContext(base, headers);
    }

    public static ServiceContext create() {
        return new ServiceContext();
    }

    public String getBase() {
        return this.base;
    }

    public ParamData<String> getHeaders() {
        return this.headers;
    }

    public ServiceContext setBase(String base) {
        this.base = base;
        return this;
    }

    public ServiceContext setHeaders(ParamData<String> headers) {
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceContext)) {
            return false;
        }
        ServiceContext other = (ServiceContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$base = this.getBase();
        String other$base = other.getBase();
        if (this$base == null ? other$base != null : !this$base.equals(other$base)) {
            return false;
        }
        ParamData<String> this$headers = this.getHeaders();
        ParamData<String> other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $base = this.getBase();
        result = result * 59 + ($base == null ? 43 : $base.hashCode());
        ParamData<String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    public String toString() {
        return "ServiceContext(base=" + this.getBase() + ", headers=" + this.getHeaders() + ")";
    }

    public static class Builder {
        public static ServiceContext build(ServiceClient service) {
            String base = "";
            ParamData<String> headers = ParamData.newParam();
            if (FnUtil.judge(service, obj -> Objects.nonNull(obj))) {
                Header[] headersAnnotation;
                if (FnUtil.judge(service.value(), s -> Objects.nonNull(s) && !"".equals(s))) {
                    base = service.value();
                }
                if (FnUtil.judge(headersAnnotation = service.headers(), s -> ((Header[])s).length > 0)) {
                    for (Header header : headersAnnotation) {
                        headers.putData(header.name(), header.value());
                    }
                }
            }
            return ServiceContext.create(base, headers);
        }
    }
}

