/*
 * Decompiled with CFR 0.152.
 */
package cn.com.twoke.http.utils;

import cn.com.twoke.http.config.ParamData;
import cn.com.twoke.http.config.RequestContext;
import java.util.Iterator;
import java.util.Map;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public final class OkHttpUtil {
    private static OkHttpClient instance;

    public static synchronized OkHttpClient getInstance() {
        if (instance == null) {
            instance = new OkHttpClient();
        }
        return instance;
    }

    public static Call call(Request request) {
        OkHttpClient instance = OkHttpUtil.getInstance();
        return instance.newCall(request);
    }

    public static Request createRequest(RequestContext requestContext, RequestBody body) {
        return OkHttpUtil.createRequestBuilder(requestContext).method(requestContext.getMethod().toString(), body).build();
    }

    public static Request.Builder createRequestBuilder(RequestContext requestContext) {
        Request.Builder builder = new Request.Builder().url(requestContext.getUrl());
        ParamData<String> headers = requestContext.getHeaders();
        Iterator iterator = headers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry obj;
            Map.Entry entry = obj = iterator.next();
            builder.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        return builder;
    }
}

