/*
 * Decompiled with CFR 0.152.
 */
package cn.com.twoke.http.creator;

import cn.com.twoke.http.annotation.Api;
import cn.com.twoke.http.annotation.Body;
import cn.com.twoke.http.annotation.Header;
import cn.com.twoke.http.annotation.Param;
import cn.com.twoke.http.annotation.PathVariable;
import cn.com.twoke.http.annotation.ServiceClient;
import cn.com.twoke.http.config.ParamData;
import cn.com.twoke.http.config.RequestContext;
import cn.com.twoke.http.config.ServiceContext;
import cn.com.twoke.http.manager.ParserManager;
import cn.com.twoke.http.manager.SimpleParserManager;
import cn.com.twoke.http.parser.GetParser;
import cn.com.twoke.http.parser.PostParser;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.Objects;

public class FaceCreator {
    private static final ParserManager parserManager = new SimpleParserManager();

    private static <T> T convert(Object obj) {
        return (T)obj;
    }

    public static <T> T getFace(Class<T> clazz) {
        ServiceClient serviceClientAnnotation = clazz.getDeclaredAnnotation(ServiceClient.class);
        ServiceContext serviceContext = ServiceContext.Builder.build(serviceClientAnnotation);
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (proxy, method, args) -> {
            RequestContext.Builder requestBuilder = new RequestContext.Builder(serviceContext);
            Annotation[][] parametersAnnotations = method.getParameterAnnotations();
            StringBuilder params = new StringBuilder("?");
            Api apiAnnotation = method.getAnnotation(Api.class);
            ParamData<String> headers = ParamData.newParam();
            for (Header header : apiAnnotation.headers()) {
                headers.putData(header.name(), header.value());
            }
            String url = apiAnnotation.value();
            for (int i = 0; Objects.nonNull(args) && i < args.length; ++i) {
                Annotation[] parameterAnnotations = parametersAnnotations[i];
                Object value = args[i];
                for (Annotation parameterAnnotation : parameterAnnotations) {
                    if (parameterAnnotation instanceof PathVariable) {
                        PathVariable variable = (PathVariable)FaceCreator.convert(parameterAnnotation);
                        url = url.replace("{" + variable.name() + "}", value.toString());
                        continue;
                    }
                    if (parameterAnnotation instanceof Header) {
                        Header header = (Header)FaceCreator.convert(parameterAnnotation);
                        headers.putData(header.name(), value.toString());
                        continue;
                    }
                    if (parameterAnnotation instanceof Param) {
                        Param param = (Param)FaceCreator.convert(parameterAnnotation);
                        params.append(MessageFormat.format("{0}={1}&", param.name(), value.toString()));
                        continue;
                    }
                    if (!(parameterAnnotation instanceof Body)) continue;
                    requestBuilder.body(value);
                }
            }
            url = params.length() == 1 ? url : url + params.substring(0, params.length() - 1);
            RequestContext requestContext = requestBuilder.url(url).function(method, args).addHeaders(headers).contentType(apiAnnotation.contentType()).method(apiAnnotation.method()).returnType(apiAnnotation.returnType()).build();
            return parserManager.parse(requestContext);
        });
    }

    static {
        parserManager.register(new GetParser());
        parserManager.register(new PostParser());
    }
}

