/*
 * Decompiled with CFR 0.152.
 */
package cn.com.twoke.http.config;

import cn.com.twoke.http.config.ParamData;
import cn.com.twoke.http.config.RequestFunction;
import cn.com.twoke.http.config.ServiceContext;
import cn.com.twoke.http.type.ContentType;
import cn.com.twoke.http.type.MethodType;
import cn.com.twoke.http.type.ReturnType;
import java.lang.reflect.Method;
import java.text.MessageFormat;

public class RequestContext {
    private String url;
    private ParamData<String> headers = ParamData.newParam();
    private MethodType method;
    private ContentType contentType;
    private RequestFunction function;
    private ReturnType returnType;
    private Object body;

    private RequestContext() {
    }

    public String getUrl() {
        return this.url;
    }

    public ParamData<String> getHeaders() {
        return this.headers;
    }

    public MethodType getMethod() {
        return this.method;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public RequestFunction getFunction() {
        return this.function;
    }

    public ReturnType getReturnType() {
        return this.returnType;
    }

    public Object getBody() {
        return this.body;
    }

    public RequestContext setUrl(String url) {
        this.url = url;
        return this;
    }

    public RequestContext setHeaders(ParamData<String> headers) {
        this.headers = headers;
        return this;
    }

    public RequestContext setMethod(MethodType method) {
        this.method = method;
        return this;
    }

    public RequestContext setContentType(ContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public RequestContext setFunction(RequestFunction function) {
        this.function = function;
        return this;
    }

    public RequestContext setReturnType(ReturnType returnType) {
        this.returnType = returnType;
        return this;
    }

    public RequestContext setBody(Object body) {
        this.body = body;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestContext)) {
            return false;
        }
        RequestContext other = (RequestContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        ParamData<String> this$headers = this.getHeaders();
        ParamData<String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        MethodType this$method = this.getMethod();
        MethodType other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        ContentType this$contentType = this.getContentType();
        ContentType other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !((Object)((Object)this$contentType)).equals((Object)other$contentType)) {
            return false;
        }
        RequestFunction this$function = this.getFunction();
        RequestFunction other$function = other.getFunction();
        if (this$function == null ? other$function != null : !((Object)this$function).equals(other$function)) {
            return false;
        }
        ReturnType this$returnType = this.getReturnType();
        ReturnType other$returnType = other.getReturnType();
        if (this$returnType == null ? other$returnType != null : !((Object)((Object)this$returnType)).equals((Object)other$returnType)) {
            return false;
        }
        Object this$body = this.getBody();
        Object other$body = other.getBody();
        return !(this$body == null ? other$body != null : !this$body.equals(other$body));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        ParamData<String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        MethodType $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        ContentType $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : ((Object)((Object)$contentType)).hashCode());
        RequestFunction $function = this.getFunction();
        result = result * 59 + ($function == null ? 43 : ((Object)$function).hashCode());
        ReturnType $returnType = this.getReturnType();
        result = result * 59 + ($returnType == null ? 43 : ((Object)((Object)$returnType)).hashCode());
        Object $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        return result;
    }

    public String toString() {
        return "RequestContext(url=" + this.getUrl() + ", headers=" + this.getHeaders() + ", method=" + (Object)((Object)this.getMethod()) + ", contentType=" + (Object)((Object)this.getContentType()) + ", function=" + this.getFunction() + ", returnType=" + (Object)((Object)this.getReturnType()) + ", body=" + this.getBody() + ")";
    }

    public static class Builder {
        private String base;
        private String suffixUrl;
        private MethodType method;
        private ContentType contentType;
        private RequestFunction function;
        private ReturnType returnType;
        private Object body;
        private ParamData<String> headers = ParamData.newParam();

        public Builder(ServiceContext context) {
            this.base = context.getBase();
            this.headers.putAll(context.getHeaders());
        }

        public Builder url(String url) {
            this.suffixUrl = url;
            return this;
        }

        public Builder method(MethodType method) {
            this.method = method;
            return this;
        }

        public Builder contentType(ContentType contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public Builder addHeaders(ParamData<String> headers) {
            this.headers.putAll(headers);
            return this;
        }

        public Builder body(Object body) {
            this.body = body;
            return this;
        }

        public Builder function(Method function, Object ... args) {
            this.function = new RequestFunction(function, args);
            return this;
        }

        public Builder returnType(ReturnType returnType) {
            this.returnType = returnType;
            return this;
        }

        public RequestContext build() {
            String url = MessageFormat.format("{0}{1}", this.base, this.suffixUrl);
            return new RequestContext().setUrl(url).setMethod(this.method).setBody(this.body).setFunction(this.function).setContentType(this.contentType).setReturnType(this.returnType).setHeaders(this.headers);
        }
    }
}

