/*
 * Decompiled with CFR 0.152.
 */
package cn.com.twoke.http.parser.mapping;

import cn.com.twoke.http.annotation.Header;
import cn.com.twoke.http.annotation.mapping.GetMapping;
import cn.com.twoke.http.annotation.mapping.PostMapping;
import cn.com.twoke.http.annotation.mapping.RequestMapping;
import cn.com.twoke.http.parser.mapping.MappingAdapter;
import cn.com.twoke.http.parser.mapping.MappingAdapterWrapper;
import cn.com.twoke.http.type.ContentType;
import cn.com.twoke.http.type.MethodType;
import cn.com.twoke.http.type.ReturnType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class MappingParserManager {
    public Map<Class<? extends Annotation>, MappingAdapter> registerPool;
    public static MappingParserManager MappingInstance = MappingParserManager.builder().registerPool(new HashMap<Class<? extends Annotation>, MappingAdapter>()).build();

    public <T extends Annotation> MappingParserManager register(Class<T> clazz, MappingAdapter<T> adapter) {
        this.registerPool.put(clazz, adapter);
        return this;
    }

    public MappingAdapterWrapper getMapping(Method method) {
        AtomicReference mappingAdapter = new AtomicReference();
        this.registerPool.keySet().forEach(item -> {
            Object annotation = method.getDeclaredAnnotation(item);
            if (Objects.nonNull(annotation)) {
                MappingAdapterWrapper mappingAdapterWrapper = MappingAdapterWrapper.builder().adapter(this.registerPool.get(item)).annotation(annotation).build();
                mappingAdapter.set(mappingAdapterWrapper);
                return;
            }
        });
        if (Objects.nonNull(mappingAdapter.get())) {
            return (MappingAdapterWrapper)mappingAdapter.get();
        }
        throw new RuntimeException("error");
    }

    MappingParserManager(Map<Class<? extends Annotation>, MappingAdapter> registerPool) {
        this.registerPool = registerPool;
    }

    public static MappingParserManagerBuilder builder() {
        return new MappingParserManagerBuilder();
    }

    static {
        MappingInstance.register(RequestMapping.class, new MappingAdapter<RequestMapping>(){

            @Override
            public String getUrl(RequestMapping requestMapping) {
                return requestMapping.value();
            }

            @Override
            public ReturnType getReturnType(RequestMapping requestMapping) {
                return requestMapping.returnType();
            }

            @Override
            public ContentType getContentType(RequestMapping requestMapping) {
                return requestMapping.contentType();
            }

            @Override
            public Header[] getHeaders(RequestMapping requestMapping) {
                return requestMapping.headers();
            }

            @Override
            public MethodType getMethodType(RequestMapping requestMapping) {
                return requestMapping.method();
            }
        });
        MappingInstance.register(GetMapping.class, new MappingAdapter<GetMapping>(){

            @Override
            public String getUrl(GetMapping getMapping) {
                return getMapping.value();
            }

            @Override
            public ReturnType getReturnType(GetMapping getMapping) {
                return getMapping.returnType();
            }

            @Override
            public ContentType getContentType(GetMapping getMapping) {
                return getMapping.contentType();
            }

            @Override
            public Header[] getHeaders(GetMapping getMapping) {
                return getMapping.headers();
            }

            @Override
            public MethodType getMethodType(GetMapping getMapping) {
                return MethodType.GET;
            }
        });
        MappingInstance.register(PostMapping.class, new MappingAdapter<PostMapping>(){

            @Override
            public String getUrl(PostMapping postMapping) {
                return postMapping.value();
            }

            @Override
            public ReturnType getReturnType(PostMapping postMapping) {
                return postMapping.returnType();
            }

            @Override
            public ContentType getContentType(PostMapping postMapping) {
                return postMapping.contentType();
            }

            @Override
            public Header[] getHeaders(PostMapping postMapping) {
                return postMapping.headers();
            }

            @Override
            public MethodType getMethodType(PostMapping postMapping) {
                return MethodType.POST;
            }
        });
    }

    public static class MappingParserManagerBuilder {
        private Map<Class<? extends Annotation>, MappingAdapter> registerPool;

        MappingParserManagerBuilder() {
        }

        public MappingParserManagerBuilder registerPool(Map<Class<? extends Annotation>, MappingAdapter> registerPool) {
            this.registerPool = registerPool;
            return this;
        }

        public MappingParserManager build() {
            return new MappingParserManager(this.registerPool);
        }

        public String toString() {
            return "MappingParserManager.MappingParserManagerBuilder(registerPool=" + this.registerPool + ")";
        }
    }
}

