/*
 * Decompiled with CFR 0.152.
 */
package cn.com.vastbase.jdbc;

import cn.com.vastbase.Driver;
import cn.com.vastbase.PGResultSetMetaData;
import cn.com.vastbase.core.BaseConnection;
import cn.com.vastbase.core.Field;
import cn.com.vastbase.core.ServerVersion;
import cn.com.vastbase.jdbc.ClientLogic;
import cn.com.vastbase.jdbc.DbCompatibility;
import cn.com.vastbase.jdbc.FieldMetadata;
import cn.com.vastbase.util.GT;
import cn.com.vastbase.util.Gettable;
import cn.com.vastbase.util.GettableHashMap;
import cn.com.vastbase.util.JdbcBlackHole;
import cn.com.vastbase.util.PSQLException;
import cn.com.vastbase.util.PSQLState;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;

public class PgResultSetMetaData
implements ResultSetMetaData,
PGResultSetMetaData {
    protected final BaseConnection connection;
    protected final Field[] fields;
    private boolean fieldInfoFetched;

    public PgResultSetMetaData(BaseConnection connection, Field[] fields) {
        this.connection = connection;
        this.fields = fields;
        this.fieldInfoFetched = false;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.fields.length;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.fetchFieldMetaData();
        Field field = this.getField(column);
        FieldMetadata metadata = field.getMetadata();
        return metadata != null && metadata.autoIncrement;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        Field field = this.getField(column);
        if (this.isCleintLogicOn().booleanValue() && ClientLogic.isClientLogicField(field.getOID())) {
            return this.connection.getTypeInfo().isCaseSensitive(field.getMod());
        }
        return this.connection.getTypeInfo().isCaseSensitive(field.getOID());
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        String type_name = this.getPGType(column);
        return type_name.equals("cash") || type_name.equals("money");
    }

    @Override
    public int isNullable(int column) throws SQLException {
        this.fetchFieldMetaData();
        Field field = this.getField(column);
        if (field.getMetadata() == null) {
            return 2;
        }
        return field.getMetadata().nullable;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        Field field = this.getField(column);
        if (this.isCleintLogicOn().booleanValue() && ClientLogic.isClientLogicField(field.getOID())) {
            this.fetchFieldMetaData();
            return this.connection.getTypeInfo().isSigned(field.getMod());
        }
        return this.connection.getTypeInfo().isSigned(field.getOID());
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        Field field = this.getField(column);
        if (this.isCleintLogicOn().booleanValue() && ClientLogic.isClientLogicField(field.getOID())) {
            this.fetchFieldMetaData();
            return this.connection.getTypeInfo().getDisplaySize(field.getMod(), field.getMetadata().clientLogicOriginalMod);
        }
        return this.connection.getTypeInfo().getDisplaySize(field.getOID(), field.getMod());
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        Field field = this.getField(column);
        String columnLabel = field.getColumnLabel();
        if (DbCompatibility.ORACLE == this.connection.getDbCompatibility() && !this.isMixedCase(columnLabel)) {
            return columnLabel.toUpperCase(Locale.US);
        }
        return columnLabel;
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumnLabel(column);
    }

    @Override
    public String getBaseColumnName(int column) throws SQLException {
        Field field = this.getField(column);
        if (field.getTableOid() == 0) {
            return "";
        }
        this.fetchFieldMetaData();
        if (field.getMetadata() == null) {
            return "";
        }
        String baseColumnName = field.getMetadata().columnName;
        if (DbCompatibility.ORACLE == this.connection.getDbCompatibility() && !this.isMixedCase(baseColumnName)) {
            return baseColumnName.toUpperCase(Locale.US);
        }
        return baseColumnName;
    }

    private boolean isMixedCase(String str) {
        boolean hasLowerCase = false;
        boolean hasUpperCase = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isLowerCase(c)) {
                hasLowerCase = true;
            }
            if (Character.isUpperCase(c)) {
                hasUpperCase = true;
            }
            if (!hasLowerCase || !hasUpperCase) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.getBaseSchemaName(column);
    }

    private boolean populateFieldsWithMetadata(Gettable<FieldMetadata.Key, FieldMetadata> metadata) {
        boolean allOk = true;
        for (Field field : this.fields) {
            if (field.getMetadata() != null) continue;
            FieldMetadata fieldMetadata = metadata.get(new FieldMetadata.Key(field.getTableOid(), field.getPositionInTable()));
            if (fieldMetadata == null) {
                allOk = false;
                continue;
            }
            field.setMetadata(fieldMetadata);
        }
        this.fieldInfoFetched |= allOk;
        return allOk;
    }

    private Boolean isCleintLogicOn() {
        ClientLogic clientLogic = this.connection.getClientLogic();
        if (clientLogic == null) {
            return false;
        }
        return true;
    }

    private StringBuilder getSql() {
        StringBuilder sql = new StringBuilder("SELECT c.oid, a.attnum, a.attname, c.relname, n.nspname, a.attnotnull OR (t.typtype = 'd' AND t.typnotnull), ");
        if (this.connection.haveMinimumServerVersion(ServerVersion.v10)) {
            sql.append("a.attidentity != '' OR pg_catalog.pg_get_expr(d.adbin, d.adrelid) LIKE '%nextval(%' ");
        } else {
            sql.append("pg_catalog.pg_get_expr(d.adbin, d.adrelid) LIKE '%nextval(%' ");
        }
        if (this.isCleintLogicOn().booleanValue()) {
            sql.append(",data_type_original_oid, data_type_original_mod ");
        }
        sql.append("FROM pg_catalog.pg_class c JOIN pg_catalog.pg_namespace n ON (c.relnamespace = n.oid) JOIN pg_catalog.pg_attribute a ON (c.oid = a.attrelid) ");
        if (this.isCleintLogicOn().booleanValue()) {
            sql.append("LEFT JOIN pg_catalog.gs_encrypted_columns ce ON (a.attrelid=ce.rel_id AND a.attname = ce.column_name)");
        }
        sql.append("JOIN pg_catalog.pg_type t ON (a.atttypid = t.oid) LEFT JOIN pg_catalog.pg_attrdef d ON (d.adrelid = a.attrelid AND d.adnum = a.attnum) JOIN (");
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSql(StringBuilder sql) throws SQLException {
        Statement stmt = this.connection.createStatement();
        ResultSet rs = null;
        GettableHashMap<FieldMetadata.Key, FieldMetadata> md = new GettableHashMap<FieldMetadata.Key, FieldMetadata>();
        String execSql = sql.toString();
        try {
            rs = stmt.executeQuery(execSql);
            while (rs.next()) {
                int table = (int)rs.getLong(1);
                int column = (int)rs.getLong(2);
                String columnName = rs.getString(3);
                String tableName = rs.getString(4);
                String schemaName = rs.getString(5);
                int clientLogicOriginalMod = 0;
                int nullable = rs.getBoolean(6) ? 0 : 1;
                boolean autoIncrement = rs.getBoolean(7);
                if (this.isCleintLogicOn().booleanValue()) {
                    clientLogicOriginalMod = rs.getInt(9);
                }
                FieldMetadata fieldMetadata = new FieldMetadata(columnName, tableName, schemaName, nullable, autoIncrement, clientLogicOriginalMod);
                FieldMetadata.Key key = new FieldMetadata.Key(table, column);
                md.put(key, fieldMetadata);
            }
        }
        finally {
            JdbcBlackHole.close(rs);
            JdbcBlackHole.close(stmt);
        }
        this.populateFieldsWithMetadata(md);
        this.connection.getFieldMetadataCache().putAll(md);
    }

    private void fetchFieldMetaData() throws SQLException {
        if (this.fieldInfoFetched) {
            return;
        }
        if (this.populateFieldsWithMetadata(this.connection.getFieldMetadataCache())) {
            return;
        }
        StringBuilder sql = this.getSql();
        boolean hasSourceInfo = false;
        for (Field field : this.fields) {
            if (field.getMetadata() != null) continue;
            if (hasSourceInfo) {
                sql.append(" UNION ALL ");
            }
            sql.append("SELECT ");
            sql.append(field.getTableOid());
            if (!hasSourceInfo) {
                sql.append(" AS oid ");
            }
            sql.append(", ");
            sql.append(field.getPositionInTable());
            if (!hasSourceInfo) {
                sql.append(" AS attnum");
            }
            if (hasSourceInfo) continue;
            hasSourceInfo = true;
        }
        sql.append(") vals ON (c.oid = vals.oid AND a.attnum = vals.attnum) ");
        if (!hasSourceInfo) {
            this.fieldInfoFetched = true;
            return;
        }
        this.executeSql(sql);
    }

    @Override
    public String getBaseSchemaName(int column) throws SQLException {
        this.fetchFieldMetaData();
        Field field = this.getField(column);
        if (field.getMetadata() == null) {
            return "";
        }
        return field.getMetadata().schemaName;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        Field field = this.getField(column);
        if (this.isCleintLogicOn().booleanValue() && ClientLogic.isClientLogicField(field.getOID())) {
            this.fetchFieldMetaData();
            return this.connection.getTypeInfo().getPrecision(field.getMod(), field.getMetadata().clientLogicOriginalMod);
        }
        return this.connection.getTypeInfo().getPrecision(field.getOID(), field.getMod());
    }

    @Override
    public int getScale(int column) throws SQLException {
        Field field = this.getField(column);
        if (this.isCleintLogicOn().booleanValue() && ClientLogic.isClientLogicField(field.getOID())) {
            this.fetchFieldMetaData();
            return this.connection.getTypeInfo().getScale(field.getMod(), field.getMetadata().clientLogicOriginalMod);
        }
        return this.connection.getTypeInfo().getScale(field.getOID(), field.getMod());
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.getBaseTableName(column);
    }

    @Override
    public String getBaseTableName(int column) throws SQLException {
        this.fetchFieldMetaData();
        Field field = this.getField(column);
        if (field.getMetadata() == null) {
            return "";
        }
        return field.getMetadata().tableName;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.getSQLType(column);
    }

    @Override
    public int getFormat(int column) throws SQLException {
        return this.getField(column).getFormat();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        String type = this.getPGType(column);
        if (this.isAutoIncrement(column)) {
            if ("int4".equals(type)) {
                return "serial";
            }
            if ("int8".equals(type)) {
                return "bigserial";
            }
        }
        return type;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    public Field getField(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", columnIndex, this.fields.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        return this.fields[columnIndex - 1];
    }

    protected String getPGType(int columnIndex) throws SQLException {
        if (this.isCleintLogicOn().booleanValue() && ClientLogic.isClientLogicField(this.getField(columnIndex).getOID())) {
            return this.connection.getTypeInfo().getPGType(this.getField(columnIndex).getMod());
        }
        return this.connection.getTypeInfo().getPGType(this.getField(columnIndex).getOID());
    }

    protected int getSQLType(int columnIndex) throws SQLException {
        if (this.isCleintLogicOn().booleanValue() && ClientLogic.isClientLogicField(this.getField(columnIndex).getOID())) {
            return this.connection.getTypeInfo().getSQLType(this.getField(columnIndex).getMod());
        }
        return this.connection.getTypeInfo().getSQLType(this.getField(columnIndex).getOID());
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        String result;
        Field field = this.getField(column);
        int actualOID = field.getOID();
        if (ClientLogic.isClientLogicField(actualOID)) {
            actualOID = field.getMod();
        }
        if ((result = this.connection.getTypeInfo().getJavaClass(actualOID)) != null) {
            return result;
        }
        int sqlType = this.getSQLType(column);
        switch (sqlType) {
            case 2003: {
                return "java.sql.Array";
            }
        }
        String type = this.getPGType(column);
        if ("unknown".equals(type)) {
            return "java.lang.String";
        }
        return "java.lang.Object";
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "isWrapperFor(Class<?>)");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "unwrap(Class<T>)");
    }
}

