/*
 * Decompiled with CFR 0.152.
 */
package cn.com.vastbase.replication.fluent.logical;

import cn.com.vastbase.core.BaseConnection;
import cn.com.vastbase.replication.fluent.AbstractCreateSlotBuilder;
import cn.com.vastbase.replication.fluent.logical.ChainedLogicalCreateSlotBuilder;
import java.sql.SQLException;
import java.sql.Statement;

public class LogicalCreateSlotBuilder
extends AbstractCreateSlotBuilder<ChainedLogicalCreateSlotBuilder>
implements ChainedLogicalCreateSlotBuilder {
    private String outputPlugin;
    private BaseConnection connection;

    public LogicalCreateSlotBuilder(BaseConnection connection) {
        this.connection = connection;
    }

    @Override
    protected ChainedLogicalCreateSlotBuilder self() {
        return this;
    }

    @Override
    public ChainedLogicalCreateSlotBuilder withOutputPlugin(String outputPlugin) {
        this.outputPlugin = outputPlugin;
        return this.self();
    }

    @Override
    public void make() throws SQLException {
        if (this.outputPlugin == null || this.outputPlugin.isEmpty()) {
            throw new IllegalArgumentException("OutputPlugin required parameter for logical replication slot");
        }
        if (this.slotName == null || this.slotName.isEmpty()) {
            throw new IllegalArgumentException("Replication slotName can't be null");
        }
        try (Statement statement = this.connection.createStatement();){
            statement.execute(String.format("CREATE_REPLICATION_SLOT %s LOGICAL %s", this.slotName, this.outputPlugin));
        }
    }
}

