/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.jackson;

import cn.crane4j.core.util.ObjectUtils;
import cn.crane4j.extension.jackson.JsonNodeAssistant;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class JacksonJsonNodeAssistant
implements JsonNodeAssistant<JsonNode> {
    private final @NonNull ObjectMapper objectMapper;
    protected PropertyNamingStrategy namingStrategy;

    public JacksonJsonNodeAssistant(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.namingStrategy = (PropertyNamingStrategy)ObjectUtils.defaultIfNull((Object)objectMapper.getPropertyNamingStrategy(), (Object)objectMapper.getSerializationConfig().getPropertyNamingStrategy());
    }

    @Override
    public String determinePropertyName(String propertyName) {
        return Objects.isNull(this.namingStrategy) ? propertyName : this.namingStrategy.nameForField((MapperConfig)this.objectMapper.getSerializationConfig(), null, propertyName);
    }

    @Override
    public JsonNode convertTargetToJsonNode(Object target) {
        return target instanceof JsonNode ? (JsonNode)target : this.objectMapper.valueToTree(target);
    }

    public void setNamingStrategy(PropertyNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }
}

