/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.jackson;

import cn.crane4j.extension.jackson.JsonNodeAssistant;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;

public class JsonNodeHandler {
    private final JsonNodeAssistant<JsonNode> jsonNodeAssistant;

    public Object read(Object node, String propertyName) {
        String actualPropertyName;
        JsonNode jsonNode = this.jsonNodeAssistant.convertTargetToJsonNode(node);
        JsonNode result = jsonNode.get(actualPropertyName = this.jsonNodeAssistant.determinePropertyName(propertyName));
        return Objects.nonNull(result) && result.isValueNode() ? result.asText() : result;
    }

    public Object write(Object target, String propertyName, Object value) {
        ObjectNode objectNode = (ObjectNode)target;
        String actualPropertyName = this.jsonNodeAssistant.determinePropertyName(propertyName);
        JsonNode jsonNode = this.jsonNodeAssistant.convertTargetToJsonNode(value);
        return objectNode.set(actualPropertyName, jsonNode);
    }

    public JsonNodeHandler(JsonNodeAssistant<JsonNode> jsonNodeAssistant) {
        this.jsonNodeAssistant = jsonNodeAssistant;
    }
}

