/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.jackson;

import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.reflect.PropDesc;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.extension.jackson.JsonNodeAssistant;
import cn.crane4j.extension.jackson.JsonNodeHandler;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JsonNodePropertyOperator
extends JsonNodeHandler
implements PropertyOperator {
    private final JsonNodePropDesc jsonNodePropDesc = new JsonNodePropDesc();
    private final PropertyOperator propertyOperator;

    public JsonNodePropertyOperator(JsonNodeAssistant<JsonNode> jsonNodeAssistant, PropertyOperator propertyOperator) {
        super(jsonNodeAssistant);
        this.propertyOperator = propertyOperator;
    }

    public @NonNull PropDesc getPropertyDescriptor(Class<?> targetType) {
        return TreeNode.class.isAssignableFrom(targetType) ? this.jsonNodePropDesc : this.propertyOperator.getPropertyDescriptor(targetType);
    }

    private class JsonNodePropDesc
    implements PropDesc {
        private JsonNodePropDesc() {
        }

        public Class<?> getBeanType() {
            return TreeNode.class;
        }

        public @Nullable MethodInvoker getGetter(String propertyName) {
            return (t, args) -> JsonNodePropertyOperator.this.read(t, propertyName);
        }

        public @Nullable MethodInvoker getSetter(String propertyName) {
            return (t, args) -> JsonNodePropertyOperator.this.write(t, propertyName, args[0]);
        }
    }
}

