package cn.crushes.cloud.core.pay.wechat;

import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * The type Wechat pay configured condition.
 *
 * @author youta
 */
@Order
public class WechatPayConfiguredCondition extends SpringBootCondition {

    /**
     * The constant STRING_WECHAT_V3_MAP.
     */
    private static final Bindable<Map<String, WechatPayProperties.V3>> STRING_WECHAT_V3_MAP = Bindable
            .mapOf(String.class, WechatPayProperties.V3.class);

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConditionMessage.Builder message = ConditionMessage.forCondition("Wechat Pay V3 Configured Condition");
        Map<String, WechatPayProperties.V3> v3 = getV3(context.getEnvironment());
        if (!v3.isEmpty()) {
            return ConditionOutcome.match(message.foundExactly("registered wechat mchIds " + v3.values().stream()
                    .map(WechatPayProperties.V3::getMchId).collect(Collectors.joining(", "))));
        }
        return ConditionOutcome.noMatch(message.notAvailable("registered wechat pay configs"));
    }

    private Map<String, WechatPayProperties.V3> getV3(Environment environment) {
        return Binder.get(environment)
                .bind("wechat.pay.v3", STRING_WECHAT_V3_MAP)
                .orElse(Collections.emptyMap());
    }

}
