package cn.crushes.cloud.core.pay.wechat.v2.model.allocation;

import cn.crushes.cloud.core.pay.wechat.v2.model.BaseModel;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * The type Profit sharing return model.
 *
 * @author youta
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ProfitSharingReturnModel extends BaseModel {

    /**
     * 商户号.
     * <p>
     * 微信支付分配的商户号
     */
    private String mchId;

    /**
     * 公众账号ID.
     * <p>
     * 微信分配的公众账号ID
     */
    private String appid;
    private String orderId;
    private String outOrderNo;
    private String outReturnNo;
    private String returnAccountType;
    private String returnAccount;
    private String returnAmount;
    private String description;

}
