package cn.crushes.cloud.core.pay.wechat.v3.model.busifavor;

import lombok.Data;

import java.util.List;

/**
 * 固定周期有效时间段
 * <p>
 * 可以设置多个星期下的多个可用时间段，比如每周二10点到18点，用户自定义字段。
 *
 * @author youta
 */
@Data
public class AvailableWeek {

    /**
     * 当天可用时间段
     * <p>
     * 可以填写多个时间段，最多不超过2个。
     */
    private List<AvailableDayTimeItem> availableDayTime;
    /**
     * 可用星期数
     * <p>
     * 0代表周日，1代表周一，以此类推
     * <p>
     * 当填写{@link #availableDayTime}时，{@code weekDay}必填
     */
    private List<Integer> weekDay;
}