package cn.crushes.cloud.core.pay.wechat.v3.model.discountcard;

import cn.crushes.cloud.core.pay.wechat.enumeration.StrategyType;
import lombok.Data;

/**
 * 优惠使用纪录列表对象
 *
 * @author youta
 */
@Data
public class RewardUsageRecord {

    /**
     * 优惠金额
     *
     * <ol>
     *  <li>优惠金额，用户此项本次享受的优惠对应的优惠总金额，单位：分，必须大于0。</li>
     *  <li>子优惠已享金额累计≤创建模板时配置的此子优惠的价值金额 例如：优惠为【满10元减3元优惠券4张】时，用户一次消费使用了2张优惠券，优惠金额为本次优惠总金额6元，优惠数量为本次使用优惠的优惠券数量2张</li>
     * </ol>
     */
    private Long amount;
    /**
     * 优惠使用描述
     */
    private String description;
    /**
     * 备注说明
     */
    private String remark;
    /**
     * 优惠Id
     */
    private String rewardId;
    /**
     * 优惠使用纪录流水号
     */
    private String rewardUsageSerialNo;
    /**
     * 优惠使用数量
     */
    private Long usageCount;
    /**
     * 优惠使用时间
     */
    private String usageTime;
    /**
     * 优惠使用类型
     */
    private StrategyType usageType;

}
