/*
 * Decompiled with CFR 0.152.
 */
package cn.crushes.cloud.core.pay.wechat.v2;

import cn.crushes.cloud.core.pay.wechat.WechatPayProperties;
import cn.crushes.cloud.core.pay.wechat.v2.WechatV2Client;
import cn.crushes.cloud.core.pay.wechat.v2.model.allocation.MultiProfitSharingModel;
import cn.crushes.cloud.core.pay.wechat.v2.model.allocation.MultiProfitSharingSModel;
import cn.crushes.cloud.core.pay.wechat.v2.model.allocation.ProfitSharingAddReceiverModel;
import cn.crushes.cloud.core.pay.wechat.v2.model.allocation.ProfitSharingAddReceiverSModel;
import cn.crushes.cloud.core.pay.wechat.v2.model.allocation.ProfitSharingFinishModel;
import cn.crushes.cloud.core.pay.wechat.v2.model.allocation.ProfitSharingModel;
import cn.crushes.cloud.core.pay.wechat.v2.model.allocation.ProfitSharingOrderAmountQueryModel;
import cn.crushes.cloud.core.pay.wechat.v2.model.allocation.ProfitSharingQueryModel;
import cn.crushes.cloud.core.pay.wechat.v2.model.allocation.ProfitSharingRemoveReceiverModel;
import cn.crushes.cloud.core.pay.wechat.v2.model.allocation.ProfitSharingRemoveReceiverSModel;
import cn.crushes.cloud.core.pay.wechat.v2.model.allocation.ProfitSharingReturnModel;
import cn.crushes.cloud.core.pay.wechat.v2.model.allocation.ProfitSharingReturnQueryModel;
import cn.crushes.cloud.core.pay.wechat.v2.model.allocation.ProfitSharingSModel;
import cn.crushes.cloud.core.pay.wechat.v2.model.allocation.Receiver;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class WechatAllocationApi {
    private static final Logger log = LoggerFactory.getLogger(WechatAllocationApi.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final WechatV2Client wechatV2Client;

    public WechatAllocationApi(WechatV2Client wechatV2Client) {
        this.wechatV2Client = wechatV2Client;
    }

    public JsonNode profitSharing(ProfitSharingModel profitSharingModel) {
        ProfitSharingSModel profitSharingSModel = new ProfitSharingSModel();
        List<Receiver> receivers = profitSharingModel.getReceivers();
        profitSharingSModel.setReceivers(MAPPER.writeValueAsString(receivers));
        WechatPayProperties.V3 v3 = this.wechatV2Client.getWechatMetaBean().getV3();
        profitSharingSModel.setAppid(v3.getAppId());
        profitSharingSModel.setMchId(v3.getMchId());
        profitSharingSModel.setTransactionId(profitSharingModel.getTransactionId());
        profitSharingSModel.setOutOrderNo(profitSharingModel.getOutOrderNo());
        profitSharingSModel.certPath(v3.getCertPath());
        profitSharingSModel.signType("HMAC-SHA256");
        return this.wechatV2Client.wechatPayRequest(profitSharingSModel, HttpMethod.POST, "https://api.mch.weixin.qq.com/secapi/pay/profitsharing");
    }

    public JsonNode multiProfitSharing(MultiProfitSharingModel multiProfitSharingModel) {
        MultiProfitSharingSModel multiProfitSharingSModel = new MultiProfitSharingSModel();
        List<Receiver> receivers = multiProfitSharingModel.getReceivers();
        multiProfitSharingSModel.setReceivers(MAPPER.writeValueAsString(receivers));
        WechatPayProperties.V3 v3 = this.wechatV2Client.getWechatMetaBean().getV3();
        multiProfitSharingSModel.setAppid(v3.getAppId());
        multiProfitSharingSModel.setMchId(v3.getMchId());
        multiProfitSharingSModel.setTransactionId(multiProfitSharingModel.getTransactionId());
        multiProfitSharingSModel.setOutOrderNo(multiProfitSharingModel.getOutOrderNo());
        multiProfitSharingSModel.certPath(v3.getCertPath());
        multiProfitSharingSModel.signType("HMAC-SHA256");
        return this.wechatV2Client.wechatPayRequest(multiProfitSharingSModel, HttpMethod.POST, "https://api.mch.weixin.qq.com/secapi/pay/multiprofitsharing");
    }

    public JsonNode profitSharingQuery(ProfitSharingQueryModel profitSharingQueryModel) {
        WechatPayProperties.V3 v3 = this.wechatV2Client.getWechatMetaBean().getV3();
        profitSharingQueryModel.setMchId(v3.getMchId());
        profitSharingQueryModel.certPath(v3.getCertPath());
        profitSharingQueryModel.signType("HMAC-SHA256");
        return this.wechatV2Client.wechatPayRequest(profitSharingQueryModel, HttpMethod.POST, "https://api.mch.weixin.qq.com/pay/profitsharingquery");
    }

    public JsonNode profitSharingAddReceiver(ProfitSharingAddReceiverModel profitSharingAddReceiverModel) {
        ProfitSharingAddReceiverSModel profitSharingAddReceiverSModel = new ProfitSharingAddReceiverSModel();
        ProfitSharingAddReceiverModel.Receiver receiver = profitSharingAddReceiverModel.getReceiver();
        profitSharingAddReceiverSModel.setReceiver(MAPPER.writeValueAsString((Object)receiver));
        WechatPayProperties.V3 v3 = this.wechatV2Client.getWechatMetaBean().getV3();
        profitSharingAddReceiverSModel.setAppid(v3.getAppId());
        profitSharingAddReceiverSModel.setMchId(v3.getMchId());
        profitSharingAddReceiverSModel.certPath(v3.getCertPath());
        profitSharingAddReceiverSModel.signType("HMAC-SHA256");
        return this.wechatV2Client.wechatPayRequest(profitSharingAddReceiverSModel, HttpMethod.POST, "https://api.mch.weixin.qq.com/pay/profitsharingaddreceiver");
    }

    public JsonNode profitSharingRemoveReceiver(ProfitSharingRemoveReceiverModel profitSharingRemoveReceiverModel) {
        ProfitSharingRemoveReceiverSModel profitSharingRemoveReceiverSModel = new ProfitSharingRemoveReceiverSModel();
        ProfitSharingRemoveReceiverModel.Receiver receiver = profitSharingRemoveReceiverModel.getReceiver();
        profitSharingRemoveReceiverSModel.setReceiver(MAPPER.writeValueAsString((Object)receiver));
        WechatPayProperties.V3 v3 = this.wechatV2Client.getWechatMetaBean().getV3();
        profitSharingRemoveReceiverSModel.setAppid(v3.getAppId());
        profitSharingRemoveReceiverSModel.setMchId(v3.getMchId());
        profitSharingRemoveReceiverSModel.certPath(v3.getCertPath());
        profitSharingRemoveReceiverSModel.signType("HMAC-SHA256");
        return this.wechatV2Client.wechatPayRequest(profitSharingRemoveReceiverSModel, HttpMethod.POST, "https://api.mch.weixin.qq.com/pay/profitsharingremovereceiver");
    }

    public JsonNode profitSharingFinish(ProfitSharingFinishModel profitSharingFinishModel) {
        WechatPayProperties.V3 v3 = this.wechatV2Client.getWechatMetaBean().getV3();
        profitSharingFinishModel.setAppid(v3.getAppId());
        profitSharingFinishModel.setMchId(v3.getMchId());
        profitSharingFinishModel.certPath(v3.getCertPath());
        profitSharingFinishModel.signType("HMAC-SHA256");
        return this.wechatV2Client.wechatPayRequest(profitSharingFinishModel, HttpMethod.POST, "https://api.mch.weixin.qq.com/secapi/pay/profitsharingfinish");
    }

    public JsonNode profitSharingOrderAmountQuery(ProfitSharingOrderAmountQueryModel profitSharingOrderAmountQueryModel) {
        WechatPayProperties.V3 v3 = this.wechatV2Client.getWechatMetaBean().getV3();
        profitSharingOrderAmountQueryModel.setMchId(v3.getMchId());
        profitSharingOrderAmountQueryModel.certPath(v3.getCertPath());
        profitSharingOrderAmountQueryModel.signType("HMAC-SHA256");
        return this.wechatV2Client.wechatPayRequest(profitSharingOrderAmountQueryModel, HttpMethod.POST, "https://api.mch.weixin.qq.com/pay/profitsharingorderamountquery");
    }

    public JsonNode profitSharingReturn(ProfitSharingReturnModel profitSharingReturnModel) {
        WechatPayProperties.V3 v3 = this.wechatV2Client.getWechatMetaBean().getV3();
        profitSharingReturnModel.setAppid(v3.getAppId());
        profitSharingReturnModel.setMchId(v3.getMchId());
        profitSharingReturnModel.certPath(v3.getCertPath());
        profitSharingReturnModel.signType("HMAC-SHA256");
        return this.wechatV2Client.wechatPayRequest(profitSharingReturnModel, HttpMethod.POST, "https://api.mch.weixin.qq.com/secapi/pay/profitsharingreturn");
    }

    public JsonNode profitSharingReturnQuery(ProfitSharingReturnQueryModel profitSharingReturnQueryModel) {
        WechatPayProperties.V3 v3 = this.wechatV2Client.getWechatMetaBean().getV3();
        profitSharingReturnQueryModel.setAppid(v3.getAppId());
        profitSharingReturnQueryModel.setMchId(v3.getMchId());
        profitSharingReturnQueryModel.certPath(v3.getCertPath());
        profitSharingReturnQueryModel.signType("HMAC-SHA256");
        return this.wechatV2Client.wechatPayRequest(profitSharingReturnQueryModel, HttpMethod.POST, "https://api.mch.weixin.qq.com/pay/profitsharingreturnquery");
    }

    static {
        MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true).registerModule((Module)new JavaTimeModule());
    }
}

