/*
 * Decompiled with CFR 0.152.
 */
package cn.crushes.cloud.core.pay.wechat.v2;

import cn.crushes.cloud.core.pay.wechat.WechatPayProperties;
import cn.crushes.cloud.core.pay.wechat.v2.WechatV2Client;
import cn.crushes.cloud.core.pay.wechat.v2.model.GroupRedpackModel;
import cn.crushes.cloud.core.pay.wechat.v2.model.RedPackInfoModel;
import cn.crushes.cloud.core.pay.wechat.v2.model.RedPackModel;
import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.http.HttpMethod;

public class WechatPayRedPackApi {
    private final WechatV2Client wechatV2Client;

    public WechatPayRedPackApi(WechatV2Client wechatV2Client) {
        this.wechatV2Client = wechatV2Client;
    }

    public JsonNode sendRedPack(RedPackModel redPackModel) {
        WechatPayProperties.V3 v3 = this.wechatV2Client.getWechatMetaBean().getV3();
        redPackModel.setWxappid(v3.getAppId());
        redPackModel.setMchId(v3.getMchId());
        return this.wechatV2Client.wechatPayRequest(redPackModel, HttpMethod.POST, "https://api.mch.weixin.qq.com/mmpaymkttransfers/sendredpack");
    }

    public JsonNode sendRedPack(GroupRedpackModel groupRedPackModel) {
        WechatPayProperties.V3 v3 = this.wechatV2Client.getWechatMetaBean().getV3();
        groupRedPackModel.setWxappid(v3.getAppId());
        groupRedPackModel.setMchId(v3.getMchId());
        return this.wechatV2Client.wechatPayRequest(groupRedPackModel, HttpMethod.POST, "https://api.mch.weixin.qq.com/mmpaymkttransfers/sendgroupredpack");
    }

    public JsonNode redPackInfo(RedPackInfoModel redPackInfoModel) {
        WechatPayProperties.V3 v3 = this.wechatV2Client.getWechatMetaBean().getV3();
        redPackInfoModel.setAppid(v3.getAppId());
        redPackInfoModel.setMchId(v3.getMchId());
        return this.wechatV2Client.wechatPayRequest(redPackInfoModel, HttpMethod.POST, "https://api.mch.weixin.qq.com/mmpaymkttransfers/gethbinfo");
    }
}

