/*
 * Decompiled with CFR 0.152.
 */
package cn.crushes.cloud.core.pay.wechat.v2;

import cn.crushes.cloud.core.pay.wechat.WechatPayProperties;
import cn.crushes.cloud.core.pay.wechat.v2.WechatV2Client;
import cn.crushes.cloud.core.pay.wechat.v2.model.TransferInfoModel;
import cn.crushes.cloud.core.pay.wechat.v2.model.TransferModel;
import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.http.HttpMethod;

public class WechatPayTransfersApi {
    private final WechatV2Client wechatV2Client;

    public WechatPayTransfersApi(WechatV2Client wechatV2Client) {
        this.wechatV2Client = wechatV2Client;
    }

    public JsonNode transfer(TransferModel transferModel) {
        WechatPayProperties.V3 v3 = this.wechatV2Client.getWechatMetaBean().getV3();
        transferModel.setMchAppid(v3.getAppId());
        transferModel.setMchid(v3.getMchId());
        return this.wechatV2Client.wechatPayRequest(transferModel, HttpMethod.POST, "https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers");
    }

    public JsonNode transferInfo(TransferInfoModel transferModel) {
        WechatPayProperties.V3 v3 = this.wechatV2Client.getWechatMetaBean().getV3();
        transferModel.setAppid(v3.getAppId());
        transferModel.setMchId(v3.getMchId());
        return this.wechatV2Client.wechatPayRequest(transferModel, HttpMethod.POST, "https://api.mch.weixin.qq.com/mmpaymkttransfers/gettransferinfo");
    }
}

