/*
 * Decompiled with CFR 0.152.
 */
package cn.crushes.cloud.core.pay.wechat.v3;

import cn.crushes.cloud.core.pay.wechat.v2.WechatAllocationApi;
import cn.crushes.cloud.core.pay.wechat.v2.WechatPayRedPackApi;
import cn.crushes.cloud.core.pay.wechat.v2.WechatPayTransfersApi;
import cn.crushes.cloud.core.pay.wechat.v2.WechatV2Client;
import cn.crushes.cloud.core.pay.wechat.v3.WechatBatchTransferApi;
import cn.crushes.cloud.core.pay.wechat.v3.WechatCombinePayApi;
import cn.crushes.cloud.core.pay.wechat.v3.WechatDirectPayApi;
import cn.crushes.cloud.core.pay.wechat.v3.WechatDiscountCardApi;
import cn.crushes.cloud.core.pay.wechat.v3.WechatMarketingBusiFavorApi;
import cn.crushes.cloud.core.pay.wechat.v3.WechatMarketingFavorApi;
import cn.crushes.cloud.core.pay.wechat.v3.WechatMetaBean;
import cn.crushes.cloud.core.pay.wechat.v3.WechatPartnerPayApi;
import cn.crushes.cloud.core.pay.wechat.v3.WechatPayCallback;
import cn.crushes.cloud.core.pay.wechat.v3.WechatPayClient;
import cn.crushes.cloud.core.pay.wechat.v3.WechatPayScoreApi;

public class WechatApiProvider {
    private final WechatPayClient wechatPayClient;

    public WechatApiProvider(WechatPayClient wechatPayClient) {
        this.wechatPayClient = wechatPayClient;
    }

    public WechatMarketingFavorApi favorApi(String tenantId) {
        return new WechatMarketingFavorApi(this.wechatPayClient, tenantId);
    }

    public WechatDirectPayApi directPayApi(String tenantId) {
        return new WechatDirectPayApi(this.wechatPayClient, tenantId);
    }

    public WechatPartnerPayApi partnerPayApi(String tenantId) {
        return new WechatPartnerPayApi(this.wechatPayClient, tenantId);
    }

    public WechatCombinePayApi combinePayApi(String tenantId) {
        return new WechatCombinePayApi(this.wechatPayClient, tenantId);
    }

    public WechatPayScoreApi payScoreApi(String tenantId) {
        return new WechatPayScoreApi(this.wechatPayClient, tenantId);
    }

    public WechatDiscountCardApi discountCardApi(String tenantId) {
        return new WechatDiscountCardApi(this.wechatPayClient, tenantId);
    }

    public WechatMarketingBusiFavorApi busiFavorApi(String tenantId) {
        return new WechatMarketingBusiFavorApi(this.wechatPayClient, tenantId);
    }

    public WechatBatchTransferApi batchTransferApi(String tenantId) {
        return new WechatBatchTransferApi(this.wechatPayClient, tenantId);
    }

    public WechatPayCallback callback(String tenantId) {
        return new WechatPayCallback(this.wechatPayClient.signatureProvider(), tenantId);
    }

    public WechatPayRedPackApi redpackApi(String tenantId) {
        WechatMetaBean wechatMeta = this.wechatPayClient.signatureProvider().wechatMetaContainer().getWechatMeta(tenantId);
        WechatV2Client wechatV2Client = new WechatV2Client(wechatMeta);
        return new WechatPayRedPackApi(wechatV2Client);
    }

    public WechatPayTransfersApi transfersApi(String tenantId) {
        WechatMetaBean wechatMeta = this.wechatPayClient.signatureProvider().wechatMetaContainer().getWechatMeta(tenantId);
        WechatV2Client wechatV2Client = new WechatV2Client(wechatMeta);
        return new WechatPayTransfersApi(wechatV2Client);
    }

    public WechatAllocationApi allocationApi(String tenantId) {
        WechatMetaBean wechatMeta = this.wechatPayClient.signatureProvider().wechatMetaContainer().getWechatMeta(tenantId);
        WechatV2Client wechatV2Client = new WechatV2Client(wechatMeta);
        return new WechatAllocationApi(wechatV2Client);
    }
}

