/*
 * Decompiled with CFR 0.152.
 */
package cn.crushes.cloud.core.pay.wechat.v3;

import cn.crushes.cloud.core.common.exception.PayException;
import cn.crushes.cloud.core.pay.wechat.v3.SignatureProvider;
import cn.crushes.cloud.core.pay.wechat.v3.model.CallbackParams;
import cn.crushes.cloud.core.pay.wechat.v3.model.CouponConsumeData;
import cn.crushes.cloud.core.pay.wechat.v3.model.ProfitSharingConsumeData;
import cn.crushes.cloud.core.pay.wechat.v3.model.RefundConsumeData;
import cn.crushes.cloud.core.pay.wechat.v3.model.ResponseSignVerifyParams;
import cn.crushes.cloud.core.pay.wechat.v3.model.TransactionConsumeData;
import cn.crushes.cloud.core.pay.wechat.v3.model.busifavor.BusiFavorReceiveConsumeData;
import cn.crushes.cloud.core.pay.wechat.v3.model.combine.CombineTransactionConsumeData;
import cn.crushes.cloud.core.pay.wechat.v3.model.discountcard.DiscountCardAcceptedConsumeData;
import cn.crushes.cloud.core.pay.wechat.v3.model.discountcard.DiscountCardAgreementEndConsumeData;
import cn.crushes.cloud.core.pay.wechat.v3.model.discountcard.DiscountCardConsumer;
import cn.crushes.cloud.core.pay.wechat.v3.model.discountcard.DiscountCardUserPaidConsumeData;
import cn.crushes.cloud.core.pay.wechat.v3.model.payscore.PayScoreConsumer;
import cn.crushes.cloud.core.pay.wechat.v3.model.payscore.PayScoreUserConfirmConsumeData;
import cn.crushes.cloud.core.pay.wechat.v3.model.payscore.PayScoreUserPaidConsumeData;
import cn.crushes.cloud.core.pay.wechat.v3.model.payscore.PayScoreUserPermissionConsumeData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class WechatPayCallback {
    private static final Logger log = LoggerFactory.getLogger(WechatPayCallback.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final SignatureProvider signatureProvider;
    private final String tenantId;

    public WechatPayCallback(SignatureProvider signatureProvider, String tenantId) {
        this.signatureProvider = signatureProvider;
        Assert.hasText((String)tenantId, (String)"tenantId is required");
        this.tenantId = tenantId;
    }

    public Map<String, ?> profitSharingCallback(ResponseSignVerifyParams params, Consumer<ProfitSharingConsumeData> consumeDataConsumer) {
        String data = this.callback(params, EventType.TRANSACTION);
        ProfitSharingConsumeData consumeData = (ProfitSharingConsumeData)MAPPER.readValue(data, ProfitSharingConsumeData.class);
        consumeDataConsumer.accept(consumeData);
        HashMap<String, Object> responseBody = new HashMap<String, Object>(2);
        responseBody.put("code", 200);
        responseBody.put("message", "SUCCESS");
        return responseBody;
    }

    public Map<String, ?> couponCallback(ResponseSignVerifyParams params, Consumer<CouponConsumeData> consumeDataConsumer) {
        String data = this.callback(params, EventType.COUPON_USE);
        CouponConsumeData consumeData = (CouponConsumeData)MAPPER.readValue(data, CouponConsumeData.class);
        consumeDataConsumer.accept(consumeData);
        HashMap<String, Object> responseBody = new HashMap<String, Object>(2);
        responseBody.put("code", 200);
        responseBody.put("message", "SUCCESS");
        return responseBody;
    }

    public Map<String, ?> transactionCallback(ResponseSignVerifyParams params, Consumer<TransactionConsumeData> consumeDataConsumer) {
        String data = this.callback(params, EventType.TRANSACTION);
        TransactionConsumeData consumeData = (TransactionConsumeData)MAPPER.readValue(data, TransactionConsumeData.class);
        consumeDataConsumer.accept(consumeData);
        return Collections.singletonMap("code", "SUCCESS");
    }

    public Map<String, ?> combineTransactionCallback(ResponseSignVerifyParams params, Consumer<CombineTransactionConsumeData> consumeDataConsumer) {
        String data = this.callback(params, EventType.TRANSACTION);
        CombineTransactionConsumeData consumeData = (CombineTransactionConsumeData)MAPPER.readValue(data, CombineTransactionConsumeData.class);
        consumeDataConsumer.accept(consumeData);
        return Collections.singletonMap("code", "SUCCESS");
    }

    public Map<String, ?> payscoreUserOrderCallback(ResponseSignVerifyParams params, PayScoreConsumer payScoreConsumer) {
        CallbackParams callbackParams = this.resolve(params);
        String eventType = callbackParams.getEventType();
        if (Objects.equals(eventType, EventType.PAYSCORE_USER_CONFIRM.event)) {
            String data = this.decrypt(callbackParams);
            PayScoreUserConfirmConsumeData confirmConsumeData = (PayScoreUserConfirmConsumeData)MAPPER.readValue(data, PayScoreUserConfirmConsumeData.class);
            payScoreConsumer.getConfirmConsumeDataConsumer().accept(confirmConsumeData);
        } else if (Objects.equals(eventType, EventType.PAYSCORE_USER_PAID.event)) {
            String data = this.decrypt(callbackParams);
            PayScoreUserPaidConsumeData paidConsumeData = (PayScoreUserPaidConsumeData)MAPPER.readValue(data, PayScoreUserPaidConsumeData.class);
            payScoreConsumer.getPaidConsumeDataConsumer().accept(paidConsumeData);
        } else {
            log.error("wechat pay event type is not matched, callbackParams {}", (Object)callbackParams);
            throw new PayException(" wechat pay event type is not matched");
        }
        return Collections.singletonMap("code", "SUCCESS");
    }

    public Map<String, ?> permissionCallback(ResponseSignVerifyParams params, Consumer<PayScoreUserPermissionConsumeData> consumeDataConsumer) {
        boolean closed;
        CallbackParams callbackParams = this.resolve(params);
        String eventType = callbackParams.getEventType();
        if (Objects.equals(eventType, EventType.PAYSCORE_USER_OPEN.event)) {
            closed = false;
        } else if (Objects.equals(eventType, EventType.PAYSCORE_USER_CLOSE.event)) {
            closed = true;
        } else {
            log.error("wechat pay event type is not matched, callbackParams {}", (Object)callbackParams);
            throw new PayException(" wechat pay event type is not matched");
        }
        String data = this.decrypt(callbackParams);
        PayScoreUserPermissionConsumeData consumeData = (PayScoreUserPermissionConsumeData)MAPPER.readValue(data, PayScoreUserPermissionConsumeData.class);
        consumeData.setClosed(closed);
        consumeDataConsumer.accept(consumeData);
        return Collections.singletonMap("code", "SUCCESS");
    }

    public Map<String, ?> discountCardCallback(ResponseSignVerifyParams params, DiscountCardConsumer discountCardConsumer) {
        CallbackParams callbackParams = this.resolve(params);
        String eventType = callbackParams.getEventType();
        if (Objects.equals(eventType, EventType.DISCOUNT_CARD_AGREEMENT_ENDED.event)) {
            String data = this.decrypt(callbackParams);
            DiscountCardAgreementEndConsumeData agreementEndConsumeData = (DiscountCardAgreementEndConsumeData)MAPPER.readValue(data, DiscountCardAgreementEndConsumeData.class);
            discountCardConsumer.getAgreementEndConsumeDataConsumer().accept(agreementEndConsumeData);
        } else if (Objects.equals(eventType, EventType.DISCOUNT_CARD_USER_ACCEPTED.event)) {
            String data = this.decrypt(callbackParams);
            DiscountCardAcceptedConsumeData acceptedConsumeData = (DiscountCardAcceptedConsumeData)MAPPER.readValue(data, DiscountCardAcceptedConsumeData.class);
            discountCardConsumer.getAcceptedConsumeDataConsumer().accept(acceptedConsumeData);
        } else if (Objects.equals(eventType, EventType.DISCOUNT_CARD_USER_PAID.event)) {
            String data = this.decrypt(callbackParams);
            DiscountCardUserPaidConsumeData paidConsumeData = (DiscountCardUserPaidConsumeData)MAPPER.readValue(data, DiscountCardUserPaidConsumeData.class);
            discountCardConsumer.getCardUserPaidConsumeDataConsumer().accept(paidConsumeData);
        } else {
            log.error("wechat pay event type is not matched, callbackParams {}", (Object)callbackParams);
            throw new PayException(" wechat pay event type is not matched");
        }
        return Collections.singletonMap("code", "SUCCESS");
    }

    public Map<String, ?> busiFavorReceiveCallback(ResponseSignVerifyParams params, Consumer<BusiFavorReceiveConsumeData> consumeDataConsumer) {
        CallbackParams callbackParams = this.resolve(params);
        String eventType = callbackParams.getEventType();
        if (!Objects.equals(eventType, EventType.COUPON_SEND.event)) {
            log.error("wechat pay event type is not matched, callbackParams {}", (Object)callbackParams);
            throw new PayException(" wechat pay event type is not matched");
        }
        String data = this.decrypt(callbackParams);
        BusiFavorReceiveConsumeData consumeData = (BusiFavorReceiveConsumeData)MAPPER.readValue(data, BusiFavorReceiveConsumeData.class);
        consumeDataConsumer.accept(consumeData);
        return Collections.singletonMap("code", "SUCCESS");
    }

    public Map<String, ?> refundCallback(ResponseSignVerifyParams params, Consumer<RefundConsumeData> consumeDataConsumer) {
        CallbackParams callbackParams = this.resolve(params);
        String eventType = callbackParams.getEventType();
        if (!(Objects.equals(eventType, EventType.REFUND_CLOSED.event) || Objects.equals(eventType, EventType.REFUND_ABNORMAL.event) || Objects.equals(eventType, EventType.REFUND_SUCCESS.event))) {
            log.error("wechat pay event type is not matched, callbackParams {}", (Object)callbackParams);
            throw new PayException(" wechat pay event type is not matched");
        }
        String data = this.decrypt(callbackParams);
        RefundConsumeData consumeData = (RefundConsumeData)MAPPER.readValue(data, RefundConsumeData.class);
        consumeDataConsumer.accept(consumeData);
        return Collections.singletonMap("code", "SUCCESS");
    }

    private String callback(ResponseSignVerifyParams params, EventType eventType) {
        CallbackParams callbackParams = this.resolve(params);
        if (!Objects.equals(callbackParams.getEventType(), eventType.event)) {
            log.error("wechat pay event type is not matched, callbackParams {}", (Object)callbackParams);
            throw new PayException(" wechat pay event type is not matched");
        }
        return this.decrypt(callbackParams);
    }

    private CallbackParams resolve(ResponseSignVerifyParams params) throws JsonProcessingException {
        if (this.signatureProvider.responseSignVerify(params)) {
            return (CallbackParams)MAPPER.readValue(params.getBody(), CallbackParams.class);
        }
        throw new PayException("invalid wechat pay callback");
    }

    private String decrypt(CallbackParams callbackParams) {
        CallbackParams.Resource resource = callbackParams.getResource();
        String associatedData = resource.getAssociatedData();
        String nonce = resource.getNonce();
        String ciphertext = resource.getCiphertext();
        String data = this.signatureProvider.decryptResponseBody(this.tenantId, associatedData, nonce, ciphertext);
        Assert.hasText((String)data, (String)"decryptData is required");
        return data;
    }

    static {
        MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true).registerModule((Module)new JavaTimeModule());
    }

    static enum EventType {
        PAYSCORE_USER_CONFIRM("PAYSCORE.USER_CONFIRM"),
        PAYSCORE_USER_PAID("PAYSCORE.USER_PAID"),
        PAYSCORE_USER_OPEN("PAYSCORE.USER_OPEN_SERVICE"),
        PAYSCORE_USER_CLOSE("PAYSCORE.USER_CLOSE_SERVICE"),
        DISCOUNT_CARD_USER_ACCEPTED("DISCOUNT_CARD.USER_ACCEPTED"),
        DISCOUNT_CARD_AGREEMENT_ENDED("DISCOUNT_CARD.AGREEMENT_ENDED"),
        DISCOUNT_CARD_USER_PAID("DISCOUNT_CARD.USER_PAID"),
        COUPON_USE("COUPON.USE"),
        COUPON_SEND("COUPON.SEND"),
        TRANSACTION("TRANSACTION.SUCCESS"),
        REFUND_SUCCESS("REFUND.SUCCESS"),
        REFUND_ABNORMAL("REFUND.ABNORMAL"),
        REFUND_CLOSED("REFUND.CLOSED");

        private final String event;

        private EventType(String event) {
            this.event = event;
        }
    }
}

