/*
 * Decompiled with CFR 0.152.
 */
package cn.crushes.cloud.core.pay.wechat.v3;

import cn.crushes.cloud.core.common.exception.PayException;
import cn.crushes.cloud.core.pay.wechat.WechatPayResponseErrorHandler;
import cn.crushes.cloud.core.pay.wechat.enumeration.WechatPayV3Type;
import cn.crushes.cloud.core.pay.wechat.v3.ExtensionFormHttpMessageConverter;
import cn.crushes.cloud.core.pay.wechat.v3.SignatureProvider;
import cn.crushes.cloud.core.pay.wechat.v3.WechatRequestEntity;
import cn.crushes.cloud.core.pay.wechat.v3.model.ResponseSignVerifyParams;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class WechatPayClient {
    private static final Logger log = LoggerFactory.getLogger(WechatPayClient.class);
    private final SignatureProvider signatureProvider;
    private RestOperations restOperations;

    public WechatPayClient(SignatureProvider signatureProvider) {
        this.signatureProvider = signatureProvider;
        this.applyDefaultRestTemplate();
    }

    public <M> Executor<M> withType(WechatPayV3Type wechatPayV3Type, M m) {
        return new Executor<M>(wechatPayV3Type, m, this.signatureProvider, this.restOperations);
    }

    public SignatureProvider signatureProvider() {
        return this.signatureProvider;
    }

    private void applyDefaultRestTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory());
        WechatPayResponseErrorHandler errorHandler = new WechatPayResponseErrorHandler();
        restTemplate.setErrorHandler((ResponseErrorHandler)errorHandler);
        List messageConverters = restTemplate.getMessageConverters();
        messageConverters.removeIf(httpMessageConverter -> httpMessageConverter instanceof AllEncompassingFormHttpMessageConverter);
        messageConverters.add(new ExtensionFormHttpMessageConverter());
        restTemplate.setMessageConverters(messageConverters);
        this.restOperations = restTemplate;
    }

    public static class Executor<M> {
        private final WechatPayV3Type wechatPayV3Type;
        private final RestOperations restOperations;
        private final SignatureProvider signatureProvider;
        private final M model;
        private BiFunction<WechatPayV3Type, M, RequestEntity<?>> requestEntityBiFunction;
        private Consumer<ResponseEntity<ObjectNode>> responseBodyConsumer;

        Executor(WechatPayV3Type wechatPayV3Type, M model, SignatureProvider signatureProvider, RestOperations restOperations) {
            this.wechatPayV3Type = wechatPayV3Type;
            this.model = model;
            this.signatureProvider = signatureProvider;
            this.restOperations = restOperations;
        }

        public Executor<M> function(BiFunction<WechatPayV3Type, M, RequestEntity<?>> requestEntityBiFunction) {
            this.requestEntityBiFunction = requestEntityBiFunction;
            return this;
        }

        public Executor<M> consumer(Consumer<ResponseEntity<ObjectNode>> responseBodyConsumer) {
            this.responseBodyConsumer = responseBodyConsumer;
            return this;
        }

        public void request() {
            RequestEntity<?> requestEntity = this.requestEntityBiFunction.apply(this.wechatPayV3Type, this.model);
            WechatRequestEntity<?> wechatRequestEntity = WechatRequestEntity.of(requestEntity, this.responseBodyConsumer);
            this.doExecute(this.header(true, wechatRequestEntity));
        }

        public String download() {
            RequestEntity<?> requestEntity = this.requestEntityBiFunction.apply(this.wechatPayV3Type, this.model);
            WechatRequestEntity<?> wechatRequestEntity = WechatRequestEntity.of(requestEntity, this.responseBodyConsumer);
            return this.doDownload(this.header(true, wechatRequestEntity));
        }

        public ResponseEntity<Resource> resource() {
            RequestEntity<?> requestEntity = this.requestEntityBiFunction.apply(this.wechatPayV3Type, this.model);
            WechatRequestEntity<?> wechatRequestEntity = WechatRequestEntity.of(requestEntity, this.responseBodyConsumer);
            return this.doResource(this.header(false, wechatRequestEntity));
        }

        private <T> WechatRequestEntity<T> header(boolean newLine, WechatRequestEntity<T> requestEntity) {
            String body;
            UriComponents uri = UriComponentsBuilder.fromUri((URI)requestEntity.getUrl()).build();
            Object canonicalUrl = uri.getPath();
            String encodedQuery = uri.getQuery();
            Assert.notNull((Object)canonicalUrl, (String)"canonicalUrl is required");
            if (encodedQuery != null) {
                canonicalUrl = (String)canonicalUrl + "?" + encodedQuery;
            }
            HttpMethod httpMethod = requestEntity.getMethod();
            Assert.notNull((Object)httpMethod, (String)"httpMethod is required");
            HttpHeaders headers = requestEntity.getHeaders();
            String string = body = requestEntity.hasBody() ? Objects.requireNonNull(requestEntity.getBody()).toString() : "";
            if (WechatPayV3Type.MARKETING_IMAGE_UPLOAD.pattern().contains((CharSequence)canonicalUrl)) {
                body = (String)Objects.requireNonNull(headers.get((Object)"Meta-Info")).get(0);
            }
            String tenantId = (String)Objects.requireNonNull(headers.get((Object)"Pay-TenantId")).get(0);
            String authorization = this.signatureProvider.requestSign(newLine, tenantId, httpMethod.name(), (String)canonicalUrl, body);
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.addAll((MultiValueMap)headers);
            httpHeaders.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
            if (Objects.isNull(httpHeaders.getContentType())) {
                httpHeaders.setContentType(MediaType.parseMediaType((String)"application/json;charset=UTF-8"));
            }
            httpHeaders.add("Authorization", authorization);
            httpHeaders.add("User-Agent", "X-Pay-Service");
            httpHeaders.remove((Object)"Meta-Info");
            httpHeaders.remove((Object)"Pay-TenantId");
            return requestEntity.headers(httpHeaders);
        }

        private <T> void doExecute(WechatRequestEntity<T> requestEntity) {
            ResponseEntity responseEntity = this.restOperations.exchange(requestEntity, ObjectNode.class);
            HttpHeaders headers = responseEntity.getHeaders();
            ObjectNode body = (ObjectNode)responseEntity.getBody();
            HttpStatus statusCode = responseEntity.getStatusCode();
            String requestId = headers.getFirst("Request-ID");
            if (!statusCode.is2xxSuccessful()) {
                log.error("wechat pay server error, Request-ID " + requestId + " , statusCode " + statusCode + ",result : " + body);
                throw new PayException("wechat pay server error, Request-ID " + requestId);
            }
            ResponseSignVerifyParams params = new ResponseSignVerifyParams();
            params.setWechatpaySerial(headers.getFirst("Wechatpay-Serial"));
            params.setWechatpaySignature(headers.getFirst("Wechatpay-Signature"));
            params.setWechatpayTimestamp(headers.getFirst("Wechatpay-Timestamp"));
            params.setWechatpayNonce(headers.getFirst("Wechatpay-Nonce"));
            String content = Objects.isNull(body) ? "" : body.toString();
            params.setBody(content);
            if (this.signatureProvider.responseSignVerify(params)) {
                Consumer<ResponseEntity<ObjectNode>> responseConsumer = requestEntity.getResponseBodyConsumer();
                if (Objects.nonNull(responseConsumer)) {
                    responseConsumer.accept((ResponseEntity<ObjectNode>)responseEntity);
                }
            } else {
                throw new PayException("wechat pay signature verify failed, Request-ID " + requestId);
            }
        }

        private <T> String doDownload(WechatRequestEntity<T> requestEntity) {
            ResponseEntity responseEntity = this.restOperations.exchange(requestEntity, String.class);
            HttpStatus statusCode = responseEntity.getStatusCode();
            String requestId = requestEntity.getHeaders().getFirst("Request-ID");
            if (!statusCode.is2xxSuccessful()) {
                log.error("wechat pay server error, Request-ID  " + requestId + " , statusCode " + statusCode + ",result : " + responseEntity);
                throw new PayException("wechat pay server error, Request-ID  " + requestId);
            }
            return Optional.ofNullable((String)responseEntity.getBody()).orElse("");
        }

        private <T> ResponseEntity<Resource> doResource(WechatRequestEntity<T> requestEntity) {
            ResponseEntity responseEntity = this.restOperations.exchange(requestEntity, Resource.class);
            HttpStatus statusCode = responseEntity.getStatusCode();
            String requestId = requestEntity.getHeaders().getFirst("Request-ID");
            if (!statusCode.is2xxSuccessful()) {
                log.error("wechat pay server error, Request-ID  " + requestId + " , statusCode " + statusCode + ",result : " + responseEntity);
                throw new PayException("wechat pay server error, Request-ID  " + requestId);
            }
            return responseEntity;
        }
    }
}

