/*
 * Decompiled with CFR 0.152.
 */
package cn.crushes.cloud.core.pay.wechat.v3;

import cn.crushes.cloud.core.pay.wechat.WechatPayProperties;
import cn.crushes.cloud.core.pay.wechat.enumeration.WeChatServer;
import cn.crushes.cloud.core.pay.wechat.enumeration.WechatPayV3Type;
import cn.crushes.cloud.core.pay.wechat.v3.AbstractApi;
import cn.crushes.cloud.core.pay.wechat.v3.WechatPayClient;
import cn.crushes.cloud.core.pay.wechat.v3.WechatResponseEntity;
import cn.crushes.cloud.core.pay.wechat.v3.model.payscore.CancelServiceOrderParams;
import cn.crushes.cloud.core.pay.wechat.v3.model.payscore.CompleteServiceOrderParams;
import cn.crushes.cloud.core.pay.wechat.v3.model.payscore.DirectCompleteServiceOrderParams;
import cn.crushes.cloud.core.pay.wechat.v3.model.payscore.ModifyServiceOrderParams;
import cn.crushes.cloud.core.pay.wechat.v3.model.payscore.PayServiceOrderParams;
import cn.crushes.cloud.core.pay.wechat.v3.model.payscore.PermissionsAuthCodeParams;
import cn.crushes.cloud.core.pay.wechat.v3.model.payscore.PermissionsOpenIdParams;
import cn.crushes.cloud.core.pay.wechat.v3.model.payscore.QueryServiceOrderParams;
import cn.crushes.cloud.core.pay.wechat.v3.model.payscore.ServiceOrderPermissionParams;
import cn.crushes.cloud.core.pay.wechat.v3.model.payscore.SyncServiceOrderParams;
import cn.crushes.cloud.core.pay.wechat.v3.model.payscore.UserServiceOrderParams;
import cn.crushes.cloud.core.pay.wechat.v3.model.payscore.UserServiceStateParams;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.util.Map;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class WechatPayScoreApi
extends AbstractApi {
    public WechatPayScoreApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> userServiceState(UserServiceStateParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_USER_SERVICE_STATE, params).function((wechatPayV3Type, userServiceStateParams) -> {
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            LinkedMultiValueMap expandParams = new LinkedMultiValueMap();
            expandParams.add((Object)"appid", (Object)v3.getAppId());
            expandParams.add((Object)"service_id", (Object)params.getServiceId());
            expandParams.add((Object)"openid", (Object)params.getOpenId());
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand((Map)expandParams).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> createServiceOrder(UserServiceOrderParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_CREATE_USER_SERVICE_ORDER, params).function((wechatPayV3Type, orderParams) -> {
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            orderParams.setAppid(v3.getAppId());
            orderParams.setNotifyUrl(v3.getDomain().concat(orderParams.getNotifyUrl()));
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, orderParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryServiceOrder(QueryServiceOrderParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_QUERY_USER_SERVICE_ORDER, params).function((wechatPayV3Type, orderParams) -> {
            String queryId;
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            String outOrderNo = orderParams.getOutOrderNo();
            if (StringUtils.hasText((String)outOrderNo)) {
                queryParams.add((Object)"out_order_no", (Object)outOrderNo);
            }
            if (StringUtils.hasText((String)(queryId = orderParams.getQueryId()))) {
                queryParams.add((Object)"query_id", (Object)queryId);
            }
            queryParams.add((Object)"service_id", (Object)orderParams.getServiceId());
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            queryParams.add((Object)"appid", (Object)v3.getAppId());
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> cancelServiceOrder(CancelServiceOrderParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_CANCEL_USER_SERVICE_ORDER, params).function((wechatPayV3Type, orderParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{orderParams.getOutOrderNo()}).toUri();
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            orderParams.setAppid(v3.getAppId());
            orderParams.setOutOrderNo(null);
            return this.Post(uri, orderParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> modifyServiceOrder(ModifyServiceOrderParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_MODIFY_USER_SERVICE_ORDER, params).function((wechatPayV3Type, orderParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{orderParams.getOutOrderNo()}).toUri();
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            orderParams.setAppid(v3.getAppId());
            orderParams.setOutOrderNo(null);
            return this.Post(uri, orderParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> completeServiceOrder(CompleteServiceOrderParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_COMPLETE_USER_SERVICE_ORDER, params).function((wechatPayV3Type, orderParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{orderParams.getOutOrderNo()}).toUri();
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            orderParams.setAppid(v3.getAppId());
            orderParams.setOutOrderNo(null);
            return this.Post(uri, orderParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> payServiceOrder(PayServiceOrderParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_PAY_USER_SERVICE_ORDER, params).function((wechatPayV3Type, orderParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{orderParams.getOutOrderNo()}).toUri();
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            orderParams.setAppid(v3.getAppId());
            orderParams.setOutOrderNo(null);
            return this.Post(uri, orderParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> syncServiceOrder(SyncServiceOrderParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_SYNC_USER_SERVICE_ORDER, params).function((wechatPayV3Type, orderParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{orderParams.getOutOrderNo()}).toUri();
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            orderParams.setAppid(v3.getAppId());
            orderParams.setOutOrderNo(null);
            return this.Post(uri, orderParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> directCompleteServiceOrder(DirectCompleteServiceOrderParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_DIRECT_COMPLETE, params).function((wechatPayV3Type, orderParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            orderParams.setAppid(v3.getAppId());
            String notifyUrl = orderParams.getNotifyUrl();
            if (StringUtils.hasText((String)notifyUrl)) {
                orderParams.setNotifyUrl(v3.getDomain().concat(notifyUrl));
            }
            return this.Post(uri, orderParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> permissions(ServiceOrderPermissionParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_PERMISSIONS, params).function((wechatPayV3Type, orderParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            String notifyUrl = orderParams.getNotifyUrl();
            orderParams.setAppid(v3.getAppId());
            if (StringUtils.hasText((String)notifyUrl)) {
                orderParams.setNotifyUrl(v3.getDomain().concat(notifyUrl));
            }
            return this.Post(uri, orderParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryPermissionsByAuthCode(PermissionsAuthCodeParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_PERMISSIONS_AUTH_CODE, params).function((wechatPayV3Type, orderParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).queryParam("service_id", new Object[]{orderParams.getServiceId()}).build().expand(new Object[]{orderParams.getAuthorizationCode()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> terminatePermissionsByAuthCode(PermissionsAuthCodeParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_TERMINATE_PERMISSIONS_AUTH_CODE, params).function((wechatPayV3Type, orderParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{orderParams.getAuthorizationCode()}).toUri();
            orderParams.setAuthorizationCode(null);
            return this.Post(uri, orderParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryPermissionsByOpenId(PermissionsOpenIdParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_PERMISSIONS_OPENID, params).function((wechatPayV3Type, orderParams) -> {
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).queryParam("appid", new Object[]{v3.getAppId()}).queryParam("service_id", new Object[]{orderParams.getServiceId()}).build().expand(new Object[]{orderParams.getOpenid()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> terminatePermissionsByOpenId(PermissionsOpenIdParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_TERMINATE_PERMISSIONS_OPENID, params).function((wechatPayV3Type, orderParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{orderParams.getOpenid()}).toUri();
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            orderParams.setAppid(v3.getAppId());
            orderParams.setOpenid(null);
            return this.Post(uri, orderParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }
}

