/*
 * Decompiled with CFR 0.152.
 */
package cn.crushes.cloud.core.pay.alipay;

import cn.crushes.cloud.core.common.exception.PayException;
import cn.crushes.cloud.core.pay.alipay.AliPayProperties;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.CertAlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.internal.util.file.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;

@Configuration
@ConditionalOnProperty(prefix="ali.pay", name={"v1.app-id"})
@EnableConfigurationProperties(value={AliPayProperties.class})
public class AliPayConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AliPayConfiguration.class);

    @Bean
    public AlipayClient alipayClient(AliPayProperties aliPayProperties) throws AlipayApiException {
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        AliPayProperties.V1 v1 = aliPayProperties.getV1();
        CertAlipayRequest certAlipayRequest = new CertAlipayRequest();
        propertyMapper.from(v1::getServerUrl).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setServerUrl(arg_0));
        propertyMapper.from(v1::getAppId).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setAppId(arg_0));
        propertyMapper.from(v1::getAppPrivateKeyPath).as(this::appRSAPrivateKey).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setPrivateKey(arg_0));
        propertyMapper.from(v1::getFormat).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setFormat(arg_0));
        propertyMapper.from(v1::getCharset).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setCharset(arg_0));
        propertyMapper.from(v1::getSignType).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setSignType(arg_0));
        propertyMapper.from(v1::getAppCertPublicKeyPath).as(this::getContentFromClassPath).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setCertContent(arg_0));
        propertyMapper.from(v1::getAlipayPublicCertPath).as(this::getContentFromClassPath).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setAlipayPublicCertContent(arg_0));
        propertyMapper.from(v1::getAlipayRootCertPath).as(this::getContentFromClassPath).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setRootCertContent(arg_0));
        return new DefaultAlipayClient(certAlipayRequest);
    }

    private String getContentFromClassPath(String classPath) {
        String string;
        ClassPathResource resource = new ClassPathResource(classPath);
        InputStreamReader in = new InputStreamReader(resource.getInputStream());
        try {
            string = IOUtils.toString((Reader)in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.error("ali pay root cert is invalid ,{}", (Object)e.getMessage());
                throw new PayException("ali pay root cert path is invalid");
            }
        }
        in.close();
        return string;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String appRSAPrivateKey(String classPath) {
        ClassPathResource resource = new ClassPathResource(classPath);
        try (InputStreamReader inputStreamReader = new InputStreamReader(resource.getInputStream());){
            String string;
            try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                string = bufferedReader.readLine();
            }
            return string;
        }
        catch (IOException e) {
            log.error("ali pay app private key is required ,{}", (Object)e.getMessage());
            throw new PayException("ali pay app private key is required");
        }
    }
}

