/*
 * Decompiled with CFR 0.152.
 */
package cn.crushes.cloud.core.pay.wechat.v2.model;

import cn.crushes.cloud.core.common.exception.PayException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.util.encoders.Hex;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.AlternativeJdkIdGenerator;
import org.springframework.util.Assert;
import org.springframework.util.IdGenerator;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class BaseModel {
    public static final String HMAC_SHA256 = "HMAC-SHA256";
    private static final XmlMapper XML_MAPPER = new XmlMapper();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final IdGenerator ID_GENERATOR;
    private final String nonceStr = ID_GENERATOR.generateId().toString().replaceAll("-", "");
    private String sign;
    @JsonIgnore
    private String appSecret;
    @JsonIgnore
    private String certPath;
    @JsonIgnore
    private String signType;

    public BaseModel appSecret(String appSecret) {
        this.appSecret = appSecret;
        return this;
    }

    public BaseModel certPath(String certPath) {
        this.certPath = certPath;
        return this;
    }

    public BaseModel signType(String signType) {
        this.signType = signType;
        return this;
    }

    private String xml() {
        String link = this.link(this);
        this.sign = HMAC_SHA256.equals(this.signType) ? this.hmacSha256(link) : this.md5(link);
        return XML_MAPPER.writer().withRootName("xml").writeValueAsString((Object)this);
    }

    private String md5(String src) {
        MD5Digest digest = new MD5Digest();
        byte[] bytes = src.getBytes(StandardCharsets.UTF_8);
        digest.update(bytes, 0, bytes.length);
        byte[] md5Bytes = new byte[digest.getDigestSize()];
        digest.doFinal(md5Bytes, 0);
        return Hex.toHexString((byte[])md5Bytes).toUpperCase();
    }

    private String hmacSha256(String src) {
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(this.appSecret.getBytes(), "HmacSHA256");
        sha256_HMAC.init(secret_key);
        byte[] bytes = sha256_HMAC.doFinal(src.getBytes(StandardCharsets.UTF_8));
        return Hex.toHexString((byte[])bytes).toUpperCase();
    }

    private <T> String link(T t) {
        Assert.hasText((String)this.appSecret, (String)"wechat pay appSecret is required");
        String link = OBJECT_MAPPER.writer().writeValueAsString(t).replaceAll("\":\"", "=").replaceAll("\",\"", "&").replaceAll("\\\\\"", "\"");
        return link.substring(2, link.length() - 2).concat("&key=").concat(this.appSecret);
    }

    public JsonNode request(String mchId, HttpMethod method, String url) {
        String xml = this.xml();
        RequestEntity body = RequestEntity.method((HttpMethod)method, (URI)UriComponentsBuilder.fromHttpUrl((String)url).build().toUri()).contentType(MediaType.valueOf((String)"application/x-www-form-urlencoded;charset=UTF-8")).body((Object)xml);
        ResponseEntity responseEntity = this.getRestTemplateClientAuthentication(mchId).exchange(url, method, (HttpEntity)body, String.class, new Object[0]);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            throw new PayException("wechat pay v2 error ");
        }
        String result = (String)responseEntity.getBody();
        return XML_MAPPER.readTree(result);
    }

    private RestTemplate getRestTemplateClientAuthentication(String mchId) throws IOException, UnrecoverableKeyException, CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        ClassPathResource resource = new ClassPathResource(this.certPath == null ? "wechat/apiclient_cert.p12" : this.certPath);
        char[] pem = mchId.toCharArray();
        KeyStore store = KeyStore.getInstance("PKCS12");
        store.load(resource.getInputStream(), pem);
        SSLContext sslcontext = SSLContextBuilder.create().loadKeyMaterial(store, pem).build();
        NoopHostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, (HostnameVerifier)hostnameVerifier);
        CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpclient);
        return new RestTemplate((ClientHttpRequestFactory)clientHttpRequestFactory);
    }

    public String getNonceStr() {
        return this.nonceStr;
    }

    public String getSign() {
        return this.sign;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getCertPath() {
        return this.certPath;
    }

    public String getSignType() {
        return this.signType;
    }

    static {
        XML_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL).setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        OBJECT_MAPPER.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true).setSerializationInclusion(JsonInclude.Include.NON_NULL).setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        ID_GENERATOR = new AlternativeJdkIdGenerator();
    }
}

