/*
 * Decompiled with CFR 0.152.
 */
package cn.crushes.cloud.core.pay.wechat.v3;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.StreamingHttpOutputMessage;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.GsonHttpMessageConverter;
import org.springframework.http.converter.json.JsonbHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.smile.MappingJackson2SmileHttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;

final class ExtensionFormHttpMessageConverter
extends FormHttpMessageConverter {
    private static final String BOUNDARY = "boundary";
    private static final boolean JAXB_2_PRESENT;
    private static final boolean JACKSON_2_PRESENT;
    private static final boolean JACKSON_2_XML_PRESENT;
    private static final boolean JACKSON_2_SMILE_PRESENT;
    private static final boolean GSON_PRESENT;
    private static final boolean JSONB_PRESENT;
    private final List<HttpMessageConverter<?>> partConverters = new ArrayList();

    public ExtensionFormHttpMessageConverter() {
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter();
        stringHttpMessageConverter.setWriteAcceptCharset(false);
        this.partConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        this.partConverters.add((HttpMessageConverter<?>)stringHttpMessageConverter);
        this.partConverters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        try {
            this.partConverters.add((HttpMessageConverter<?>)new SourceHttpMessageConverter());
        }
        catch (Error error) {
            // empty catch block
        }
        if (JAXB_2_PRESENT && !JACKSON_2_XML_PRESENT) {
            this.partConverters.add((HttpMessageConverter<?>)new Jaxb2RootElementHttpMessageConverter());
        }
        if (JACKSON_2_PRESENT) {
            this.partConverters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter());
        } else if (GSON_PRESENT) {
            this.partConverters.add((HttpMessageConverter<?>)new GsonHttpMessageConverter());
        } else if (JSONB_PRESENT) {
            this.partConverters.add((HttpMessageConverter<?>)new JsonbHttpMessageConverter());
        }
        if (JACKSON_2_XML_PRESENT) {
            this.partConverters.add((HttpMessageConverter<?>)new MappingJackson2XmlHttpMessageConverter());
        }
        if (JACKSON_2_SMILE_PRESENT) {
            this.partConverters.add((HttpMessageConverter<?>)new MappingJackson2SmileHttpMessageConverter());
        }
        this.setPartConverters(this.partConverters);
        this.applyDefaultCharset();
    }

    private void applyDefaultCharset() {
        for (HttpMessageConverter<?> candidate : this.partConverters) {
            AbstractHttpMessageConverter converter;
            if (!(candidate instanceof AbstractHttpMessageConverter) || (converter = (AbstractHttpMessageConverter)candidate).getDefaultCharset() == null) continue;
            converter.setDefaultCharset(DEFAULT_CHARSET);
        }
    }

    public void write(MultiValueMap<String, ?> map, @Nullable MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        if (!this.isMultipart(map, contentType)) {
            this.writeForm(map, contentType, outputMessage);
        } else {
            this.writeMultipart(map, outputMessage);
        }
    }

    private boolean isMultipart(MultiValueMap<String, ?> map, @Nullable MediaType contentType) {
        if (contentType != null) {
            return MediaType.MULTIPART_FORM_DATA.includes(contentType);
        }
        for (List values : map.values()) {
            for (Object value : values) {
                if (value == null || value instanceof String) continue;
                return true;
            }
        }
        return false;
    }

    private void writeForm(MultiValueMap<String, Object> formData, @Nullable MediaType contentType, HttpOutputMessage outputMessage) throws IOException {
        contentType = this.getMediaType(contentType);
        outputMessage.getHeaders().setContentType(contentType);
        Charset charset = contentType.getCharset();
        Assert.notNull((Object)charset, (String)"No charset");
        byte[] bytes = this.serializeForm(formData, charset).getBytes(charset);
        outputMessage.getHeaders().setContentLength((long)bytes.length);
        if (outputMessage instanceof StreamingHttpOutputMessage) {
            StreamingHttpOutputMessage streamingOutputMessage = (StreamingHttpOutputMessage)outputMessage;
            streamingOutputMessage.setBody(outputStream -> StreamUtils.copy((byte[])bytes, (OutputStream)outputStream));
        } else {
            StreamUtils.copy((byte[])bytes, (OutputStream)outputMessage.getBody());
        }
    }

    private MediaType getMediaType(@Nullable MediaType mediaType) {
        if (mediaType == null) {
            return new MediaType(MediaType.APPLICATION_FORM_URLENCODED, DEFAULT_CHARSET);
        }
        if (mediaType.getCharset() == null) {
            return new MediaType(mediaType, DEFAULT_CHARSET);
        }
        return mediaType;
    }

    private void writeMultipart(MultiValueMap<String, Object> parts, HttpOutputMessage outputMessage) throws IOException {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(1);
        parameters.put(BOUNDARY, BOUNDARY);
        MediaType contentType = new MediaType(MediaType.MULTIPART_FORM_DATA, parameters);
        HttpHeaders headers = outputMessage.getHeaders();
        headers.setContentType(contentType);
        byte[] boundaryBytes = BOUNDARY.getBytes();
        if (outputMessage instanceof StreamingHttpOutputMessage) {
            StreamingHttpOutputMessage streamingOutputMessage = (StreamingHttpOutputMessage)outputMessage;
            streamingOutputMessage.setBody(outputStream -> {
                this.writeParts(outputStream, parts, boundaryBytes);
                ExtensionFormHttpMessageConverter.writeEnd(outputStream, boundaryBytes);
            });
        } else {
            this.writeParts(outputMessage.getBody(), parts, boundaryBytes);
            ExtensionFormHttpMessageConverter.writeEnd(outputMessage.getBody(), boundaryBytes);
        }
    }

    private void writeParts(OutputStream os, MultiValueMap<String, Object> parts, byte[] boundary) throws IOException {
        for (Map.Entry entry : parts.entrySet()) {
            String name = (String)entry.getKey();
            for (Object part : (List)entry.getValue()) {
                if (part == null) continue;
                this.writeBoundary(os, boundary);
                this.writePart(name, this.getHttpEntity(part), os);
                ExtensionFormHttpMessageConverter.writeNewLine(os);
            }
        }
    }

    private void writePart(String name, HttpEntity<?> partEntity, OutputStream os) throws IOException {
        Object partBody = partEntity.getBody();
        if (partBody == null) {
            throw new IllegalStateException("Empty body for part '" + name + "': " + partEntity);
        }
        Class<?> partType = partBody.getClass();
        HttpHeaders partHeaders = partEntity.getHeaders();
        MediaType partContentType = partHeaders.getContentType();
        for (HttpMessageConverter<?> messageConverter : this.partConverters) {
            if (!messageConverter.canWrite(partType, partContentType)) continue;
            MultipartHttpOutputMessage multipartMessage = new MultipartHttpOutputMessage(os, DEFAULT_CHARSET);
            multipartMessage.getHeaders().setContentDispositionFormData(name, this.getFilename(partBody));
            if (!partHeaders.isEmpty()) {
                multipartMessage.getHeaders().putAll((Map)partHeaders);
            }
            messageConverter.write(partBody, partContentType, (HttpOutputMessage)multipartMessage);
            return;
        }
        throw new HttpMessageNotWritableException("Could not write request: no suitable HttpMessageConverter found for request type [" + partType.getName() + "]");
    }

    private void writeBoundary(OutputStream os, byte[] boundary) throws IOException {
        os.write(45);
        os.write(45);
        os.write(boundary);
        ExtensionFormHttpMessageConverter.writeNewLine(os);
    }

    private static void writeEnd(OutputStream os, byte[] boundary) throws IOException {
        os.write(45);
        os.write(45);
        os.write(boundary);
        os.write(45);
        os.write(45);
        ExtensionFormHttpMessageConverter.writeNewLine(os);
    }

    private static void writeNewLine(OutputStream os) throws IOException {
        os.write(13);
        os.write(10);
    }

    static {
        ClassLoader classLoader = AllEncompassingFormHttpMessageConverter.class.getClassLoader();
        JAXB_2_PRESENT = ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)classLoader);
        JACKSON_2_PRESENT = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)classLoader) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)classLoader);
        JACKSON_2_XML_PRESENT = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.xml.XmlMapper", (ClassLoader)classLoader);
        JACKSON_2_SMILE_PRESENT = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.smile.SmileFactory", (ClassLoader)classLoader);
        GSON_PRESENT = ClassUtils.isPresent((String)"com.google.gson.Gson", (ClassLoader)classLoader);
        JSONB_PRESENT = ClassUtils.isPresent((String)"javax.json.bind.Jsonb", (ClassLoader)classLoader);
    }

    private static class MultipartHttpOutputMessage
    implements HttpOutputMessage {
        private final OutputStream outputStream;
        private final Charset charset;
        private final HttpHeaders headers = new HttpHeaders();
        private boolean headersWritten = false;

        public MultipartHttpOutputMessage(OutputStream outputStream, Charset charset) {
            this.outputStream = outputStream;
            this.charset = charset;
        }

        public HttpHeaders getHeaders() {
            return this.headersWritten ? HttpHeaders.readOnlyHttpHeaders((HttpHeaders)this.headers) : this.headers;
        }

        public OutputStream getBody() throws IOException {
            this.writeHeaders();
            return this.outputStream;
        }

        private void writeHeaders() throws IOException {
            if (!this.headersWritten) {
                for (Map.Entry entry : this.headers.entrySet()) {
                    byte[] headerName = this.getBytes((String)entry.getKey());
                    for (String headerValueString : (List)entry.getValue()) {
                        byte[] headerValue = this.getBytes(headerValueString);
                        this.outputStream.write(headerName);
                        this.outputStream.write(58);
                        this.outputStream.write(32);
                        this.outputStream.write(headerValue);
                        ExtensionFormHttpMessageConverter.writeNewLine(this.outputStream);
                    }
                }
                ExtensionFormHttpMessageConverter.writeNewLine(this.outputStream);
                this.headersWritten = true;
            }
        }

        private byte[] getBytes(String name) {
            return name.getBytes(this.charset);
        }
    }
}

