/*
 * Decompiled with CFR 0.152.
 */
package cn.crushes.cloud.core.pay.wechat.v3;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class WechatResponseEntity<T> {
    private static final Logger log = LoggerFactory.getLogger(WechatResponseEntity.class);
    private int httpStatus;
    private T body;

    public void convert(ResponseEntity<T> responseEntity) {
        if (log.isDebugEnabled()) {
            log.debug("wechat response {}", responseEntity);
        }
        if (Objects.nonNull(responseEntity)) {
            this.httpStatus = responseEntity.getStatusCodeValue();
            this.body = responseEntity.getBody();
        } else {
            this.httpStatus = HttpStatus.REQUEST_TIMEOUT.value();
            this.body = null;
        }
    }

    public boolean is1xxInformational() {
        if (log.isDebugEnabled()) {
            log.debug("wechat httpStatus {}", (Object)this.httpStatus);
        }
        return HttpStatus.valueOf((int)this.httpStatus).is1xxInformational();
    }

    public boolean is2xxSuccessful() {
        if (log.isDebugEnabled()) {
            log.debug("wechat httpStatus {}", (Object)this.httpStatus);
        }
        return HttpStatus.valueOf((int)this.httpStatus).is2xxSuccessful();
    }

    public boolean is3xxRedirection() {
        if (log.isDebugEnabled()) {
            log.debug("wechat httpStatus {}", (Object)this.httpStatus);
        }
        return HttpStatus.valueOf((int)this.httpStatus).is3xxRedirection();
    }

    public boolean is4xxClientError() {
        if (log.isDebugEnabled()) {
            log.debug("wechat httpStatus {}", (Object)this.httpStatus);
        }
        return HttpStatus.valueOf((int)this.httpStatus).is4xxClientError();
    }

    public boolean is5xxServerError() {
        if (log.isDebugEnabled()) {
            log.debug("wechat httpStatus {}", (Object)this.httpStatus);
        }
        return HttpStatus.valueOf((int)this.httpStatus).is5xxServerError();
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public T getBody() {
        return this.body;
    }

    public void setHttpStatus(int httpStatus) {
        this.httpStatus = httpStatus;
    }

    public void setBody(T body) {
        this.body = body;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WechatResponseEntity)) {
            return false;
        }
        WechatResponseEntity other = (WechatResponseEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getHttpStatus() != other.getHttpStatus()) {
            return false;
        }
        T this$body = this.getBody();
        T other$body = other.getBody();
        return !(this$body == null ? other$body != null : !this$body.equals(other$body));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WechatResponseEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getHttpStatus();
        T $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        return result;
    }

    public String toString() {
        return "WechatResponseEntity(httpStatus=" + this.getHttpStatus() + ", body=" + this.getBody() + ")";
    }
}

