/*
 * Decompiled with CFR 0.152.
 */
package cn.crushes.cloud.core.rocket.config;

import cn.crushes.cloud.core.rocket.props.RocketProps;
import com.aliyun.openservices.ons.api.bean.OrderConsumerBean;
import com.aliyun.openservices.ons.api.bean.OrderProducerBean;
import com.aliyun.openservices.ons.api.bean.Subscription;
import com.aliyun.openservices.ons.api.order.MessageOrderListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class RocketConfig {
    private static final Logger log = LoggerFactory.getLogger(RocketConfig.class);
    @Resource
    public RocketProps rocketProps;

    protected OrderProducerBean createProducer(String groupId) {
        OrderProducerBean producerBean = new OrderProducerBean();
        Properties properties = this.getProperties();
        properties.put("GROUP_ID", groupId);
        producerBean.setProperties(properties);
        return producerBean;
    }

    protected OrderConsumerBean createConsumer(String groupId, Map<Subscription, MessageOrderListener> subscriptionTable) {
        OrderConsumerBean consumerBean = new OrderConsumerBean();
        Properties properties = this.createConsumerProperties(groupId);
        consumerBean.setProperties(properties);
        consumerBean.setSubscriptionTable(subscriptionTable);
        return consumerBean;
    }

    protected OrderConsumerBean createBbRoadCastConsumer(String groupId, Map<Subscription, MessageOrderListener> subscriptionTable) {
        OrderConsumerBean consumerBean = new OrderConsumerBean();
        Properties properties = this.createConsumerProperties(groupId, true);
        consumerBean.setProperties(properties);
        consumerBean.setSubscriptionTable(subscriptionTable);
        return consumerBean;
    }

    private Properties createConsumerProperties(String groupId) {
        return this.createConsumerProperties(groupId, false);
    }

    private Properties createConsumerProperties(String groupId, boolean isBbRoadCast) {
        Properties properties = this.getProperties();
        properties.put("GROUP_ID", groupId);
        properties.put("ConsumeThreadNums", Runtime.getRuntime().availableProcessors() * 2 + 1 + "");
        if (isBbRoadCast) {
            properties.put("MessageModel", "BROADCASTING");
        }
        return properties;
    }

    public Map<Subscription, MessageOrderListener> createSubscriptionTable(String topic, String tag, MessageOrderListener listeners) {
        Subscription subscription = new Subscription();
        subscription.setTopic(topic);
        subscription.setExpression(tag);
        HashMap<Subscription, MessageOrderListener> subscriptionTable = new HashMap<Subscription, MessageOrderListener>(2);
        if (!ObjectUtils.isEmpty((Object)listeners)) {
            subscriptionTable.put(subscription, listeners);
        }
        return subscriptionTable;
    }

    public Map<Subscription, MessageOrderListener> createSubscriptionTable(String tag, MessageOrderListener listeners) {
        Subscription subscription = new Subscription();
        subscription.setTopic(this.rocketProps.getTopic());
        subscription.setExpression(tag);
        HashMap<Subscription, MessageOrderListener> subscriptionTable = new HashMap<Subscription, MessageOrderListener>(2);
        if (!ObjectUtils.isEmpty((Object)listeners)) {
            subscriptionTable.put(subscription, listeners);
        }
        return subscriptionTable;
    }

    private Properties getProperties() {
        Properties properties = new Properties();
        properties.put("AccessKey", this.rocketProps.getAccessKey());
        properties.put("SecretKey", this.rocketProps.getSecretKey());
        properties.put("NAMESRV_ADDR", this.rocketProps.getNameAddr());
        return properties;
    }
}

