/*
 * Decompiled with CFR 0.152.
 */
package cn.crushes.cloud.core.rocket.manager;

import cn.crushes.cloud.core.common.exception.RocketMqException;
import cn.crushes.cloud.core.rocket.RocketMqClient;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.order.OrderAction;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RocketMqManager {
    private static final Logger log = LoggerFactory.getLogger(RocketMqManager.class);
    private final List<RocketMqClient> clients;

    public Optional<RocketMqClient> initialize(String tag) {
        return this.clients.stream().filter(client -> client.getTag().equals(tag)).findAny();
    }

    public OrderAction consume(Message message, boolean canRetry) {
        OrderAction action;
        RocketMqClient client = null;
        try {
            client = this.initialize(message.getTag()).orElseThrow(() -> new RocketMqException("\u521d\u59cb\u5316\u751f\u4ea7\u8005\u5904\u7406\u8005\u5931\u8d25"));
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u751f\u4ea7\u8005\u5904\u7406\u8005\u5931\u8d25", (Throwable)e);
            throw new RocketMqException("\u521d\u59cb\u5316\u751f\u4ea7\u8005\u5904\u7406\u8005\u5931\u8d25");
        }
        if (client == null) {
            log.warn("missing client by this tag [{}]", (Object)message.getTag());
            return OrderAction.Success;
        }
        String response = new String(message.getBody());
        try {
            action = client.execute(response);
        }
        catch (Exception e) {
            log.error("rocket mq process error", (Throwable)e);
            action = OrderAction.Suspend;
        }
        if (OrderAction.Suspend.equals((Object)action) && canRetry) {
            return OrderAction.Suspend;
        }
        return OrderAction.Success;
    }

    public RocketMqManager(List<RocketMqClient> clients) {
        this.clients = clients;
    }
}

