package cn.crushes.cloud.core.rocket.producer;

import cn.crushes.cloud.core.common.rocket.Event;
import cn.crushes.cloud.core.rocket.props.RocketProps;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.bean.OrderProducerBean;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.google.gson.Gson;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

/**
 * @author youta
 */
@Slf4j
public class RocketSender {

    @Resource
    private RocketProps rocketProps;


    private Message createMqMsg(Event event, String tag, String topicName, String msgJson) {
        Message mqMsg = new Message();
        mqMsg.setBody(msgJson.getBytes());
        mqMsg.setKey(event.getEventId() + "_" + tag);
        mqMsg.setTag(tag);
        mqMsg.setTopic(StringUtils.isBlank(topicName) ? rocketProps.getTopic() : topicName);
        mqMsg.setShardingKey(event.getEventId());
        return mqMsg;
    }

    private String toJson(Object obj) {
        Gson gson = new Gson();
        return gson.toJson(obj);
    }

    /**
     * 发送消息
     *
     * @param event     消息体
     * @param millis    延迟时间
     * @param topicName 主题名称
     */
    public void send(Event event, long millis, String topicName, OrderProducerBean producerBean) {
        String sendStr = this.toJson(event);
        Message mqMsg = createMqMsg(event, event.getTag(), StringUtils.isBlank(topicName) ? rocketProps.getTopic() : topicName, sendStr);
        if (millis != 0) {
            mqMsg.setStartDeliverTime(System.currentTimeMillis() + millis);
        }
        SendResult send;
        send = producerBean.send(mqMsg, event.getEventId());
        if (send != null) {
            log.info("RocketMQ tag :[{}] send success：{}", event.getTag(), send.toString());
        }
    }

    /**
     * 发送消息
     *
     * @param event     消息体
     * @param topicName 主题名称
     */
    public void send(Event event, String topicName, OrderProducerBean producerBean) {
        String sendStr = this.toJson(event);
        Message mqMsg = createMqMsg(event, event.getTag(), StringUtils.isBlank(topicName) ? rocketProps.getTopic() : topicName, sendStr);
        SendResult send;
        send = producerBean.send(mqMsg, event.getEventId());
        if (send != null) {
            log.info("RocketMQ tag :[{}] send success：{}", event.getTag(), send.toString());
        }
    }

    /**
     * 发送消息
     *
     * @param event  消息体
     * @param millis 延迟时间
     */
    public void send(Event event, long millis, OrderProducerBean producerBean) {
        String sendStr = this.toJson(event);
        Message mqMsg = createMqMsg(event, event.getTag(), rocketProps.getTopic(), sendStr);
        if (millis != 0) {
            mqMsg.setStartDeliverTime(System.currentTimeMillis() + millis);
        }
        SendResult send;
        send = producerBean.send(mqMsg, event.getEventId());
        if (send != null) {
            log.info("RocketMQ tag :[{}] send success：{}", event.getTag(), send.toString());
        }
    }

    /**
     * 发送消息
     *
     * @param event 消息体
     */
    public void send(Event event, OrderProducerBean producerBean) {
        String sendStr = this.toJson(event);
        Message mqMsg = createMqMsg(event, event.getTag(), rocketProps.getTopic(), sendStr);
        SendResult send;
        send = producerBean.send(mqMsg, event.getEventId());
        if (send != null) {
            log.info("RocketMQ tag :[{}] send success：{}", event.getTag(), send.toString());
        }
    }

    /**
     * 发送消息
     *
     * @param event     消息体
     * @param millis    延迟时间
     * @param topicName 主题名称
     */
    private void broadcast(Event event, long millis, String topicName, OrderProducerBean producerBean) {
        String sendStr = this.toJson(event);
        Message mqMsg = createMqMsg(event, event.getTag(), StringUtils.isBlank(topicName) ? rocketProps.getTopic() : topicName, sendStr);
        if (millis != 0) {
            mqMsg.setStartDeliverTime(System.currentTimeMillis() + millis);
        }
        SendResult send = producerBean.send(mqMsg, event.getEventId());
        if (send != null) {
            log.info("RocketMQ tag :[{}] send success：{}", event.getTag(), send.toString());
        }
    }

    /**
     * 发送消息
     *
     * @param event     消息体
     * @param topicName 主题名称
     */
    private void broadcast(Event event, String topicName, OrderProducerBean producerBean) {
        String sendStr = this.toJson(event);
        Message mqMsg = createMqMsg(event, event.getTag(), StringUtils.isBlank(topicName) ? rocketProps.getTopic() : topicName, sendStr);
        SendResult send = producerBean.send(mqMsg, event.getEventId());
        if (send != null) {
            log.info("RocketMQ tag :[{}] send success：{}", event.getTag(), send.toString());
        }
    }

    /**
     * 发送消息
     *
     * @param event  消息体
     * @param millis 延迟时间
     */
    private void broadcast(Event event, long millis, OrderProducerBean producerBean) {
        String sendStr = this.toJson(event);
        Message mqMsg = createMqMsg(event, event.getTag(), rocketProps.getTopic(), sendStr);
        if (millis != 0) {
            mqMsg.setStartDeliverTime(System.currentTimeMillis() + millis);
        }
        SendResult send = producerBean.send(mqMsg, event.getEventId());
        if (send != null) {
            log.info("RocketMQ tag :[{}] send success：{}", event.getTag(), send.toString());
        }
    }

    /**
     * 发送消息
     *
     * @param event 消息体
     */
    private void broadcast(Event event, OrderProducerBean producerBean) {
        String sendStr = this.toJson(event);
        Message mqMsg = createMqMsg(event, event.getTag(), rocketProps.getTopic(), sendStr);
        SendResult send = producerBean.send(mqMsg, event.getEventId());
        if (send != null) {
            log.info("RocketMQ tag :[{}] send success：{}", event.getTag(), send.toString());
        }
    }

}
