/*
 * Decompiled with CFR 0.152.
 */
package cn.crushes.cloud.core.rocket.producer;

import cn.crushes.cloud.core.common.rocket.Event;
import cn.crushes.cloud.core.rocket.props.RocketProps;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.bean.OrderProducerBean;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.google.gson.Gson;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketSender {
    private static final Logger log = LoggerFactory.getLogger(RocketSender.class);
    @Resource
    private RocketProps rocketProps;

    private Message createMqMsg(Event event, String tag, String topicName, String msgJson) {
        Message mqMsg = new Message();
        mqMsg.setBody(msgJson.getBytes());
        mqMsg.setKey(event.getEventId() + "_" + tag);
        mqMsg.setTag(tag);
        mqMsg.setTopic(StringUtils.isBlank((CharSequence)topicName) ? this.rocketProps.getTopic() : topicName);
        mqMsg.setShardingKey(event.getEventId());
        return mqMsg;
    }

    private String toJson(Object obj) {
        Gson gson = new Gson();
        return gson.toJson(obj);
    }

    public void send(Event event, long millis, String topicName, OrderProducerBean producerBean) {
        SendResult send;
        String sendStr = this.toJson(event);
        Message mqMsg = this.createMqMsg(event, event.getTag(), StringUtils.isBlank((CharSequence)topicName) ? this.rocketProps.getTopic() : topicName, sendStr);
        if (millis != 0L) {
            mqMsg.setStartDeliverTime(System.currentTimeMillis() + millis);
        }
        if ((send = producerBean.send(mqMsg, event.getEventId())) != null) {
            log.info("RocketMQ tag :[{}] send success\uff1a{}", (Object)event.getTag(), (Object)send.toString());
        }
    }

    public void send(Event event, String topicName, OrderProducerBean producerBean) {
        String sendStr = this.toJson(event);
        Message mqMsg = this.createMqMsg(event, event.getTag(), StringUtils.isBlank((CharSequence)topicName) ? this.rocketProps.getTopic() : topicName, sendStr);
        SendResult send = producerBean.send(mqMsg, event.getEventId());
        if (send != null) {
            log.info("RocketMQ tag :[{}] send success\uff1a{}", (Object)event.getTag(), (Object)send.toString());
        }
    }

    public void send(Event event, long millis, OrderProducerBean producerBean) {
        SendResult send;
        String sendStr = this.toJson(event);
        Message mqMsg = this.createMqMsg(event, event.getTag(), this.rocketProps.getTopic(), sendStr);
        if (millis != 0L) {
            mqMsg.setStartDeliverTime(System.currentTimeMillis() + millis);
        }
        if ((send = producerBean.send(mqMsg, event.getEventId())) != null) {
            log.info("RocketMQ tag :[{}] send success\uff1a{}", (Object)event.getTag(), (Object)send.toString());
        }
    }

    public void send(Event event, OrderProducerBean producerBean) {
        String sendStr = this.toJson(event);
        Message mqMsg = this.createMqMsg(event, event.getTag(), this.rocketProps.getTopic(), sendStr);
        SendResult send = producerBean.send(mqMsg, event.getEventId());
        if (send != null) {
            log.info("RocketMQ tag :[{}] send success\uff1a{}", (Object)event.getTag(), (Object)send.toString());
        }
    }

    private void broadcast(Event event, long millis, String topicName, OrderProducerBean producerBean) {
        SendResult send;
        String sendStr = this.toJson(event);
        Message mqMsg = this.createMqMsg(event, event.getTag(), StringUtils.isBlank((CharSequence)topicName) ? this.rocketProps.getTopic() : topicName, sendStr);
        if (millis != 0L) {
            mqMsg.setStartDeliverTime(System.currentTimeMillis() + millis);
        }
        if ((send = producerBean.send(mqMsg, event.getEventId())) != null) {
            log.info("RocketMQ tag :[{}] send success\uff1a{}", (Object)event.getTag(), (Object)send.toString());
        }
    }

    private void broadcast(Event event, String topicName, OrderProducerBean producerBean) {
        String sendStr = this.toJson(event);
        Message mqMsg = this.createMqMsg(event, event.getTag(), StringUtils.isBlank((CharSequence)topicName) ? this.rocketProps.getTopic() : topicName, sendStr);
        SendResult send = producerBean.send(mqMsg, event.getEventId());
        if (send != null) {
            log.info("RocketMQ tag :[{}] send success\uff1a{}", (Object)event.getTag(), (Object)send.toString());
        }
    }

    private void broadcast(Event event, long millis, OrderProducerBean producerBean) {
        SendResult send;
        String sendStr = this.toJson(event);
        Message mqMsg = this.createMqMsg(event, event.getTag(), this.rocketProps.getTopic(), sendStr);
        if (millis != 0L) {
            mqMsg.setStartDeliverTime(System.currentTimeMillis() + millis);
        }
        if ((send = producerBean.send(mqMsg, event.getEventId())) != null) {
            log.info("RocketMQ tag :[{}] send success\uff1a{}", (Object)event.getTag(), (Object)send.toString());
        }
    }

    private void broadcast(Event event, OrderProducerBean producerBean) {
        String sendStr = this.toJson(event);
        Message mqMsg = this.createMqMsg(event, event.getTag(), this.rocketProps.getTopic(), sendStr);
        SendResult send = producerBean.send(mqMsg, event.getEventId());
        if (send != null) {
            log.info("RocketMQ tag :[{}] send success\uff1a{}", (Object)event.getTag(), (Object)send.toString());
        }
    }
}

